<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE xsl:stylesheet>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:hostcms="http://www.hostcms.ru/"
	exclude-result-prefixes="hostcms">
	
	<xsl:output xmlns="http://www.w3.org/TR/xhtml1/strict" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" encoding="utf-8" indent="yes" method="html" omit-xml-declaration="no" version="1.0" media-type="text/xml"/>
	
	<!-- ФинансыНижнееМеню -->
	
	<xsl:template match="/site">
		<h4>Снаб Лифт</h4>
		
		<ul class="footer-menu list-unstyled">
			<xsl:apply-templates select="structure[show=1]"/>
		</ul>
	</xsl:template>
	
	<xsl:template match="structure">
		<!-- Определяем адрес ссылки -->
		<xsl:variable name="link">
			<xsl:choose>
				<!-- Если внешняя ссылка -->
				<xsl:when test="url != ''">
					<xsl:value-of disable-output-escaping="yes" select="url"/>
				</xsl:when>
				<!-- Иначе если внутренняя ссылка -->
				<xsl:otherwise>
					<xsl:value-of disable-output-escaping="yes" select="link"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<xsl:variable name="current_structure_id" select="/site/current_structure_id"/>
		
		<li>
			<a href="{$link}"><xsl:value-of select="name"/></a>
		</li>
		
		<xsl:if test="position() mod 3 = 0">
			<xsl:text disable-output-escaping="yes">
				&lt;/ul&gt;
				&lt;ul class="footer-menu list-unstyled"&gt;
			</xsl:text>
		</xsl:if>
	</xsl:template>
	
</xsl:stylesheet>