<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE xsl:stylesheet SYSTEM "lang://229">
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:hostcms="http://www.hostcms.ru/"
	exclude-result-prefixes="hostcms">
	<xsl:output xmlns="http://www.w3.org/TR/xhtml1/strict"  encoding="utf-8" indent="yes" method="html" omit-xml-declaration="no" version="1.0" media-type="text/xml"/>


<xsl:template match="/shop">
	
			<style type="text/css">
				td { padding: 0; border: 0;}
				table { border: none; }
				body { text-align: center; background-color: white; margin: 0; }
				.oneline { white-space: nowrap; }
				.align_center { margin-left: auto; margin-right: auto; }
				.tiny_size { font-size: 1px; }
				.align_right_text { text-align: right; }
				.align_center_text { text-align: center; }
				.align_v_top { vertical-align: top; }
				.align_v_bottom { vertical-align: bottom; }
				.max_width { width: 100%; }
				.max_height { height: 100%; }
				.tiny_width { width: 1px; }
				.tiny_height { height: 1px; }
				.cells { border-right: black 1px solid; width: 100%; }
				.cell { font-family: Arial, sans-serif; border-left: black 1px solid; border-bottom: black 1px solid; border-top: black 1px solid; font-weight: bold; font-size: 8pt; line-height: 1.1; height:4.5mm; vertical-align: bottom; text-align: center; }
				.border_bottom { border-bottom: 1px solid black; }
				.border_left { border-left: 1px solid black; }
				.border_right { border-right: 1px solid black; }
				.border_top { border-top: 1px solid black; }
				.border_bottom_bold { border-bottom: 2px solid black; }
				.border_left_bold { border-left: 2px solid black; }
				.border_right_bold { border-right: 2px solid black; }
				.border_top_bold { border-top: 2px solid black; }
				.font_size_11 { font-size: 11pt; }
				.font_size_10 { font-size: 10pt; }
				.font_size_9 { font-size: 9pt; }
				.font_size_8 { font-size: 8pt; }
				.font_size_75 { font-size: 7.5pt; }
				.font_size_7 { font-size: 7pt; }
				.font_size_6 { font-size: 6pt; }
				.font_settings { font-family: Arial, sans-serif; line-height: 1; border-bottom: black 1pt solid; text-align: center; font-weight: bold; vertical-align: bottom; }
				.font_style_italic { font-style: italic; }
				.font_family_serif { font-family: "Times New Roman", Times, serif; }
				.font_weight_bold { font-weight: bold; }
				.position_relative{position: relative;}
				.data { width: 195mm; height: 185mm; margin: 0 auto 12mm auto; }
				.class1 {height: 1px; font-size: 1px; line-height: 1;}
				.class2 {height: 2pt; border-bottom: #AAA 1pt solid;}
				.class3 {height: 1pt; overflow: hidden; font-size: 0;}
				.left_5 {left: 5px;}
				.width_16 {width: 16%;}
				.width_8 {width: 8%;}
				.width_6 {width: 6%;}
				.width_5 {width: 5%;}
				.width_4 {width: 4%;}
				.line_height_1 {line-height: 1;}
				.height_65 {height: 6.5mm;}
			</style>

			<table cellspacing="0" class="data" style="margin-bottom: 0; border-top: black 1px dashed; border-bottom: black 1px dashed;">
				<tr>
					<td style="width: 65mm;" class="tiny_height">
						<div style="width: 65mm;" class="class1"/>
					</td>
					<td style="width: 3mm;" class="tiny_height">
						<div style="width: 3mm;" class="class1"/>
					</td>
					<td style="width: 124mm;" class="tiny_height">
						<div style="width: 124mm;" class="class1"/>
					</td>
					<td style="width: 3mm;" class="tiny_height">
						<div style="width: 3mm;" class="class1"/>
					</td>
				</tr>
				<tr>
					<td style="border-right: black 1pt dotted;" class="align_right_text">
						<span class="font_size_8 position_relative left_5">
							<img width="9" height="58" src="/hostcmsfiles/images/post_2.png" />
						</span>
					</td>
					<td class="align_right_text font_size_8" style="padding: 15mm 1pt 0 0;">
						<img width="11" height="256" src="/hostcmsfiles/images/post_3.png" />
					</td>
					<td>
						<table class="max_width max_height" cellspacing="0">

							<tr>
								<td style="height: 40mm; padding-top: 4mm;">
									<div class="font_size_8 font_weight_bold font_family_serif" style="float: right;">ф.&#160;112эф</div>
									<div class="font_size_10 font_weight_bold font_family_serif" style="width: 35mm;">
										<table cellspacing="0">
											<tr>
												<td>
													<div class="font_size_8" style="float: left;">
														<img width="55" height="60" src="/hostcmsfiles/images/post_1.png" />
													</div>
													<div class="font_size_10 font_weight_bold font_family_serif" style="float: right; line-height: 1.1; text-align: center;">
							П<br/>Р<br/>И<br/>Е<br/>М</div>
												</td>
											</tr>
											<tr>
												<td class="tiny_width font_size_10 font_weight_bold font_family_serif" style="letter-spacing: -1pt; padding-top: 2mm;">
						ПОЧТА&#160;&#160;РОССИИ
												</td>
											</tr>
										</table>
										<table cellspacing="0" style="width: 100%; margin-top: 2mm;">
											<tr>
												<td class="font_family_serif oneline tiny_width align_v_bottom font_size_9 line_height_1">&#8470;</td>
												<td class="border_bottom font_settings">&#160;</td>
											</tr>
											<tr>
												<td/>
												<td class="font_family_serif align_v_top align_center_text oneline font_size_7" style="line-height: 0.9;text-align: left; padding-left: 3mm;">
							(по накладной ф. 16)
												</td>
											</tr>
											<tr>
												<td class="font_family_serif oneline tiny_width align_v_bottom font_size_9 line_height_1">&#8470;</td>
												<td class="border_bottom font_size_9 font_settings">&#160;</td>
											</tr>
											<tr>
												<td/>
												<td class="font_family_serif align_v_top align_center_text oneline font_size_7" style="line-height: 0.9;text-align: left; padding-left: 3mm;">
							(по реестру ф. 10)
												</td>
											</tr>
										</table>
									</div>
								</td>
							</tr>

							<tr>
								<td style="width: 120mm; height: 115mm; border: black 2.5pt solid; padding: 0 2pt 1pt 2pt;">
									<table class="max_width max_height" cellspacing="0">

										<tr>
											<td class="tiny_height" style="padding: 0 2pt 1pt 2pt;">
												<table class="max_width" cellspacing="0">
													<tr>
														<td class="font_family_serif oneline tiny_width align_v_bottom font_size_11 font_weight_bold font_family_serif line_height_1">
															<span class="position_relative" style="bottom: -1pt;">ПОЧТОВЫЙ&#160;ПЕРЕВОД&#160;на&#160;</span>
														</td>
														<td class="font_size_9 font_settings" style="width: 30mm;"><xsl:value-of select="floor(shop_order/total_amount)"/></td>
														<td class="font_family_serif oneline tiny_width align_v_bottom font_size_10 font_weight_bold font_family_serif line_height_1">
															<span class="position_relative" style="bottom: -1pt;">&#160;руб.&#160;</span>
														</td>
														<td class="font_size_9 font_settings" style="width: 25mm;"><xsl:value-of select="format-number((shop_order/total_amount * 100) mod 100 , '00')"/></td>
														<td class="font_family_serif oneline tiny_width align_v_bottom font_size_10 font_weight_bold font_family_serif line_height_1">
															<span class="position_relative" style="bottom: -1pt;">&#160;коп.</span>
														</td>
													</tr>
												</table>
											</td>
										</tr>
										<tr>
											<td class="font_size_9 font_settings" style="line-height: 0.1; border: none;">
												<span class="position_relative" style="top: 3.5mm;"><xsl:value-of select="numprop"></xsl:value-of></span>
											</td>
										</tr>
										<tr>
											<td style="padding: 0 2pt 0 2pt;">
												<table class="max_width" cellspacing="0">
													<tr>
														<td class="class2">
															<div class="class3">&#160;</div>
														</td>
													</tr>
													<tr>
														<td class="class2">
															<div class="class3">&#160;</div>
														</td>
													</tr>
													<tr>
														<td class="class2">
															<div class="class3">&#160;</div>
														</td>
													</tr>
													<tr>
														<td class="class2">
															<div class="class3">&#160;</div>
														</td>
													</tr>
													<tr>
														<td class="class2">
															<div class="class3">&#160;</div>
														</td>
													</tr>
													<tr>
														<td class="class2">
															<div class="class3">&#160;</div>
														</td>
													</tr>
													<tr>
														<td class="class2">
															<div class="class3">&#160;</div>
														</td>
													</tr>
													<tr>
														<td class="class2">
															<div class="class3">&#160;</div>
														</td>
													</tr>
													<tr>
														<td class="class2">
															<div class="class3">&#160;</div>
														</td>
													</tr>
													<tr>
														<td class="font_family_serif align_v_top align_center_text oneline font_size_7" style="line-height: 0.9;">
						(Рубли прописью, копейки цифрами)</td>
													</tr>
												</table>
											</td>
										</tr>

										<tr>
											<td style="padding: 0 2pt 0 2pt;">
												<table class="max_width" cellspacing="0">
													<tr>
														<td class="font_family_serif oneline tiny_width align_v_bottom font_size_9 font_weight_bold font_family_serif font_style_italic line_height_1">Кому:</td>
														<td class="font_size_9 font_settings">
															<span class="oneline"><xsl:value-of select="company/name"></xsl:value-of></span>
														</td>
													</tr>
													<tr>
														<td/>
														<td class="font_family_serif align_v_top align_center_text oneline font_size_6" style="line-height: 0.9;">
						(для юридического лица &#8211; полное или краткое наименование,
						для гражданина &#8211; фамилия, имя, отчество полностью)
														</td>
													</tr>
													<tr>
														<td class="font_family_serif oneline tiny_width align_v_bottom font_size_9 font_weight_bold font_family_serif font_style_italic line_height_1">Куда:</td>
														<td class="font_size_9 font_settings">
															<span class="oneline"><xsl:value-of select="company/directory_address/full_address"></xsl:value-of></span>
														</td>
													</tr>
													<tr>
														<td/>
														<td class="font_family_serif align_v_top align_center_text oneline font_size_6" style="line-height: 0.9;">
						(Адрес получателя)
														</td>
													</tr>
													<tr>
														<td class="font_size_9 font_settings" style="border: none;" colspan="2">&#160;</td>
													</tr>
												</table>
											</td>
										</tr>

										<tr>
											<td>
												<table class="max_width" cellspacing="0">

													<tr>
														<td class="border_left_bold border_top_bold" style="padding: 2pt 1pt 0 1pt;" rowspan="2">
															<div class="font_size_9 font_settings border_left_bold border_right_bold border_top_bold border_bottom_bold" style="width: 4mm; height: 4mm;" >
						<xsl:value-of select="paywithcash"></xsl:value-of>				</div>
														</td>
														<td class="border_top_bold border_right_bold font_family_serif align_v_top align_center_text oneline font_size_6"  style="line-height: 0.9;font-size: 7.5pt;">
															<b>
																<i>Заполняется при приеме перевода в адрес юридического лица</i>
															</b>
														</td>
														<td class="font_family_serif oneline tiny_width align_v_bottom font_size_7 font_family_serif align_right_text border_bottom_bold border_top line_height_1 align_v_top"  style="width: 9%;"
						rowspan="2">Индекс&#160;</td>
														<td class="border_bottom_bold border_top width_16" style="padding: 1pt 2pt 1pt 0;" rowspan="2">
															<table class="cells" cellspacing="0">
																<tr>
																	<td class="cell width_16">&#160;</td>
																	<td class="cell width_16">&#160;</td>
																	<td class="cell width_16">&#160;</td>
																	<td class="cell width_16">&#160;</td>
																	<td class="cell width_16">&#160;</td>
																	<td class="cell width_16">&#160;</td>
																</tr>
															</table>
														</td>
													</tr>
													<tr>
														<td class="font_size_8 font_weight_bold font_family_serif border_right_bold" style="vertical-align: bottom;">
															<span class="position_relative" style="line-height: 0.5; bottom: 0.2em;">
							Выплатить наличными деньгами</span>
														</td>
													</tr>
													<tr>
														<td colspan="4" class="border_left_bold border_right_bold" style="padding: 2mm 1pt 0 1pt">
															<table class="max_width" cellspacing="0">
																<tr>
																	<td class="font_family_serif oneline tiny_width align_v_bottom font_size_9 font_weight_bold font_family_serif font_style_italic line_height_1">ИНН:</td>
																	<td style="width: 36%;">
																		<table class="cells" cellspacing="0">
																			<tr>
																				<td class="cell width_8">
																					 <xsl:choose>
																					  <xsl:when test="substring(company/tin, 1, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/tin, 1, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell width_8">
																					<xsl:choose>
																					  <xsl:when test="substring(company/tin, 2, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/tin, 2, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell width_8">
																					<xsl:choose>
																					  <xsl:when test="substring(company/tin, 3, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/tin, 3, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell width_8">
																					<xsl:choose>
																					  <xsl:when test="substring(company/tin, 4, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/tin, 4, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell width_8">
																					<xsl:choose>
																					  <xsl:when test="substring(company/tin, 5, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/tin, 5, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell width_8">
																					<xsl:choose>
																					  <xsl:when test="substring(company/tin, 6, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/tin, 6, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell width_8">
																					<xsl:choose>
																					  <xsl:when test="substring(company/tin, 7, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/tin, 7, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell width_8">
																					<xsl:choose>
																					  <xsl:when test="substring(company/tin, 8, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/tin, 8, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell width_8">
																					<xsl:choose>
																					  <xsl:when test="substring(company/tin, 9, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/tin, 9, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell width_8">
																					<xsl:choose>
																					  <xsl:when test="substring(company/tin, 10, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/tin, 10, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell width_8">
																					<xsl:choose>
																					  <xsl:when test="substring(company/tin, 11, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/tin, 11, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell width_8">
																					<xsl:choose>
																					  <xsl:when test="substring(company/tin, 12, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/tin, 12, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																			</tr>
																		</table>
																	</td>
																	<td class="font_family_serif oneline tiny_width align_v_bottom font_size_9 font_weight_bold font_family_serif font_style_italic line_height_1">&#160;Кор/счет:</td>
																	<td style="width: 60%">
																		<table class="cells" cellspacing="0">
																			<tr>
																				<td class="cell width_5">
																					<xsl:choose>
																					  <xsl:when test="substring(company/correspondent_account, 1, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/correspondent_account, 1, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell width_5">
																					<xsl:choose>
																					  <xsl:when test="substring(company/correspondent_account, 2, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/correspondent_account, 2, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell width_5">
																					<xsl:choose>
																					  <xsl:when test="substring(company/correspondent_account, 3, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/correspondent_account, 3, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell width_5">
																					<xsl:choose>
																					  <xsl:when test="substring(company/correspondent_account, 4, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/correspondent_account, 4, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell width_5">
																					<xsl:choose>
																					  <xsl:when test="substring(company/correspondent_account, 5, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/correspondent_account, 5, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell width_5">
																					<xsl:choose>
																					  <xsl:when test="substring(company/correspondent_account, 6, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/correspondent_account, 6, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell width_5">
																					<xsl:choose>
																					  <xsl:when test="substring(company/correspondent_account, 7, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/correspondent_account, 7, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell width_5">
																					<xsl:choose>
																					  <xsl:when test="substring(company/correspondent_account, 8, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/correspondent_account, 8, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell width_5">
																					<xsl:choose>
																					  <xsl:when test="substring(company/correspondent_account, 9, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/correspondent_account, 9, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell width_5">
																					<xsl:choose>
																					  <xsl:when test="substring(company/correspondent_account, 10, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/correspondent_account, 10, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell width_5">
																					<xsl:choose>
																					  <xsl:when test="substring(company/correspondent_account, 11, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/correspondent_account, 11, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell width_5">
																					<xsl:choose>
																					  <xsl:when test="substring(company/correspondent_account, 12, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/correspondent_account, 12, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell width_5">
																					<xsl:choose>
																					  <xsl:when test="substring(company/correspondent_account, 13, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/correspondent_account, 13, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell width_5">
																					<xsl:choose>
																					  <xsl:when test="substring(company/correspondent_account, 14, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/correspondent_account, 14, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell width_5">
																					<xsl:choose>
																					  <xsl:when test="substring(company/correspondent_account, 15, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/correspondent_account, 15, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell width_5">
																					<xsl:choose>
																					  <xsl:when test="substring(company/correspondent_account, 16, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/correspondent_account, 16, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell width_5">
																					<xsl:choose>
																					  <xsl:when test="substring(company/correspondent_account, 17, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/correspondent_account, 17, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell width_5">
																					<xsl:choose>
																					  <xsl:when test="substring(company/correspondent_account, 18, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/correspondent_account, 18, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell width_5">
																					<xsl:choose>
																					  <xsl:when test="substring(company/correspondent_account, 19, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/correspondent_account, 19, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell width_5">
																					<xsl:choose>
																					  <xsl:when test="substring(company/correspondent_account, 20, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/correspondent_account, 20, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																			</tr>
																		</table>
																	</td>
																</tr>
															</table>
														</td>
													</tr>
													<tr>
														<td colspan="4" class="border_left_bold border_right_bold" style="padding: 1mm 1pt 0 1pt;">
															<table class="max_width" cellspacing="0">
																<tr>
																	<td class="font_family_serif oneline tiny_width align_v_bottom font_size_9 font_weight_bold font_family_serif font_style_italic line_height_1">Наименование&#160;банка:</td>
																	<td class="font_settings font_size_8">
																		<span class="oneline"><xsl:value-of select="company/bank_name"/></span>
																	</td>
																</tr>
															</table>
														</td>
													</tr>
													<tr>
														<td colspan="4" class="border_left_bold border_right_bold border_bottom_bold" style="padding: 1pt 1pt 1pt 1pt">
															<table class="max_width" cellspacing="0">
																<tr>
																	<td class="font_family_serif oneline tiny_width align_v_bottom font_size_9 font_weight_bold font_family_serif font_style_italic line_height_1">Рас/счет:&#160;&#160;</td>
																	<td style="width: 58%;">
																		<table class="cells" cellspacing="0">
																			<tr>
																				<td class="cell width_5">
																					<xsl:choose>
																					  <xsl:when test="substring(company/current_account, 1, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/current_account, 1, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell width_5">
																					<xsl:choose>
																					  <xsl:when test="substring(company/current_account, 2, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/current_account, 2, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell width_5">
																					<xsl:choose>
																					  <xsl:when test="substring(company/current_account, 3, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/current_account, 3, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell width_5">
																					<xsl:choose>
																					  <xsl:when test="substring(company/current_account, 4, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/current_account, 4, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell width_5">
																					<xsl:choose>
																					  <xsl:when test="substring(company/current_account, 5, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/current_account, 5, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell width_5">
																					<xsl:choose>
																					  <xsl:when test="substring(company/current_account, 6, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/current_account, 6, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell width_5">
																					<xsl:choose>
																					  <xsl:when test="substring(company/current_account, 7, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/current_account, 7, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell width_5">
																					<xsl:choose>
																					  <xsl:when test="substring(company/current_account, 8, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/current_account, 8, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell width_5">
																					<xsl:choose>
																					  <xsl:when test="substring(company/current_account, 9, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/current_account, 9, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell width_5">
																					<xsl:choose>
																					  <xsl:when test="substring(company/current_account, 10, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/current_account, 10, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell width_5">
																					<xsl:choose>
																					  <xsl:when test="substring(company/current_account, 11, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/current_account, 11, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell width_5">
																					<xsl:choose>
																					  <xsl:when test="substring(company/current_account, 12, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/current_account, 12, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell width_5">
																					<xsl:choose>
																					  <xsl:when test="substring(company/current_account, 13, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/current_account, 13, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell width_5">
																					<xsl:choose>
																					  <xsl:when test="substring(company/current_account, 14, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/current_account, 14, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell width_5">
																					<xsl:choose>
																					  <xsl:when test="substring(company/current_account, 15, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/current_account, 15, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell width_5">
																					<xsl:choose>
																					  <xsl:when test="substring(company/current_account, 16, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/current_account, 16, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell width_5">
																					<xsl:choose>
																					  <xsl:when test="substring(company/current_account, 17, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/current_account, 17, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell width_5">
																					<xsl:choose>
																					  <xsl:when test="substring(company/current_account, 18, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/current_account, 18, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell width_5">
																					<xsl:choose>
																					  <xsl:when test="substring(company/current_account, 19, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/current_account, 19, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell width_5">
																					<xsl:choose>
																					  <xsl:when test="substring(company/current_account, 20, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/current_account, 20, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																			</tr>
																		</table>
																	</td>
																	<td class="font_family_serif oneline tiny_width align_v_bottom font_size_9 font_weight_bold font_family_serif font_style_italic line_height_1" style="padding-left: 8mm;">БИК:</td>
																	<td style="width: 27%">
																		<table class="cells" cellspacing="0">
																			<tr>
																				<td class="cell" style="width: 11%;">
																					<xsl:choose>
																					  <xsl:when test="substring(company/bic, 1, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/bic, 1, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell" style="width: 11%;">
																					<xsl:choose>
																					  <xsl:when test="substring(company/bic, 2, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/bic, 2, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell" style="width: 11%;">
																					<xsl:choose>
																					  <xsl:when test="substring(company/bic, 3, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/bic, 3, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell" style="width: 11%;">
																					<xsl:choose>
																					  <xsl:when test="substring(company/bic, 4, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/bic, 4, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell" style="width: 11%;">
																					<xsl:choose>
																					  <xsl:when test="substring(company/bic, 5, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/bic, 5, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell" style="width: 11%;">
																					<xsl:choose>
																					  <xsl:when test="substring(company/bic, 6, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/bic, 6, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell" style="width: 11%;">
																					<xsl:choose>
																					  <xsl:when test="substring(company/bic, 7, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/bic, 7, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell" style="width: 11%;">
																					<xsl:choose>
																					  <xsl:when test="substring(company/bic, 8, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/bic, 8, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																				<td class="cell" style="width: 11%;">
																					<xsl:choose>
																					  <xsl:when test="substring(company/bic, 9, 1)=''">
																						&#160;
																					  </xsl:when>
																					  <xsl:otherwise>
																						<xsl:value-of select="substring(company/bic, 9, 1)"/>
																					  </xsl:otherwise>
																					</xsl:choose>
																				</td>
																			</tr>
																		</table>
																	</td>
																</tr>
															</table>
														</td>
													</tr>

												</table>
											</td>
										</tr>

										<tr>
											<td style="padding: 1pt 2pt 0 2pt;">
												<table class="max_width" cellspacing="0">
													<tr>
														<td class="font_family_serif oneline tiny_width align_v_bottom font_size_9 font_weight_bold font_family_serif font_style_italic line_height_1">От&#160;кого:</td>
														<td class="font_settings font_size_9">
															<span class="oneline"><xsl:value-of select="shop_order/surname"/>&#160;<xsl:value-of select="shop_order/name"/>&#160;<xsl:value-of select="shop_order/patronymic"/></span>
														</td>
														<td class="font_family_serif oneline align_right_text tiny_width align_v_bottom font_size_6 font_style_italic font_family_serif border_bottom line_height_1">
															<i>ИНН&#160;при&#160;<br/>его&#160;наличии&#160;</i>
														</td>
														<td style="width: 30%;">
															<table class="cells" cellspacing="0">
																<tr>
																	<td class="cell width_8">
																		<xsl:choose>
																		  <xsl:when test="substring(shop_order/tin, 1, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/tin, 1, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td class="cell width_8">
																		<xsl:choose>
																		  <xsl:when test="substring(shop_order/tin, 2, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/tin, 2, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td class="cell width_8">
																		<xsl:choose>
																		  <xsl:when test="substring(shop_order/tin, 3, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/tin, 3, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td class="cell width_8">
																		<xsl:choose>
																		  <xsl:when test="substring(shop_order/tin, 4, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/tin, 4, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td class="cell width_8">
																		<xsl:choose>
																		  <xsl:when test="substring(shop_order/tin, 5, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/tin, 5, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td class="cell width_8">
																		<xsl:choose>
																		  <xsl:when test="substring(shop_order/tin, 6, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/tin, 6, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td class="cell width_8">
																		<xsl:choose>
																		  <xsl:when test="substring(shop_order/tin, 7, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/tin, 7, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td class="cell width_8">
																		<xsl:choose>
																		  <xsl:when test="substring(shop_order/tin, 8, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/tin, 8, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td class="cell width_8">
																		<xsl:choose>
																		  <xsl:when test="substring(shop_order/tin, 9, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/tin, 9, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td class="cell width_8">
																		<xsl:choose>
																		  <xsl:when test="substring(shop_order/tin, 10, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/tin, 10, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td class="cell width_8">
																		<xsl:choose>
																		  <xsl:when test="substring(shop_order/tin, 11, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/tin, 11, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td class="cell width_8">
																		<xsl:choose>
																		  <xsl:when test="substring(shop_order/tin, 12, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/tin, 12, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose>
																	</td>
																</tr>
															</table>
														</td>
													</tr>
													<tr>
														<td/>
														<td class="font_family_serif align_v_top align_center_text oneline font_size_6" style="line-height: 0.9;">
						(фамилия, имя, отчество)
														</td>
													</tr>
													<tr>
														<td class="font_settings font_size_9" colspan="4">&#160;</td>
													</tr>
												</table>
											</td>
										</tr>

										<tr>
											<td style="padding: 0 2pt 0 2pt;">
												<table class="max_width" cellspacing="0">
													<tr>
														<td class="font_family_serif oneline tiny_width align_v_bottom font_size_9 font_weight_bold font_family_serif font_style_italic line_height_1" style="height: 5mm;">Адрес&#160;отправителя:</td>
														<td class="font_settings font_size_9" colspan="3">
															<span class="oneline"><xsl:value-of select="shop_order/address"></xsl:value-of></span>
														</td>
													</tr>
													<tr>
														<td/>
														<td class="font_family_serif align_v_top align_center_text oneline font_size_6" style="line-height: 0.9;" colspan="3">
	Адрес места жительства (регистрации), <strike>адрес пребывания</strike> (ненужное зачеркнуть)				</td>
													</tr>
													<tr>
														<td class="font_settings font_size_9" colspan="4">&#160;</td>
													</tr>
												</table>
												<table class="max_width" cellspacing="0">
													<tr>
														<td class="font_settings font_size_9">&#160;</td>
														<td class="font_family_serif oneline tiny_width align_v_bottom font_size_7 font_family_serif align_right_text border_bottom line_height_1 align_v_top">Индекс&#160;</td>
														<td style="width: 15%; padding-top: 1pt;">
															<table class="cells" cellspacing="0">
																<tr>
																	<td class="cell width_16">
																		<xsl:choose>
																		  <xsl:when test="substring(shop_order/postcode, 1, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/postcode, 1, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td class="cell width_16">
																		<xsl:choose>
																		  <xsl:when test="substring(shop_order/postcode, 2, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/postcode, 2, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td class="cell width_16">
																		<xsl:choose>
																		  <xsl:when test="substring(shop_order/postcode, 3, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/postcode, 3, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td class="cell width_16">
																		<xsl:choose>
																		  <xsl:when test="substring(shop_order/postcode, 4, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/postcode, 4, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td class="cell width_16">
																		<xsl:choose>
																		  <xsl:when test="substring(shop_order/postcode, 5, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/postcode, 5, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td class="cell width_16">
																		<xsl:choose>
																		  <xsl:when test="substring(shop_order/postcode, 6, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/postcode, 6, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose>
																	</td>
																</tr>
															</table>
														</td>
													</tr>
												</table>
											</td>
										</tr>

										<tr>
											<td style="padding: 1mm 2pt 0 2pt;">
												<table class="max_width" cellspacing="0">
													<tr>
														<td class="font_family_serif oneline tiny_width align_v_bottom font_size_9 font_weight_bold font_family_serif font_style_italic line_height_1">Сообщение:&#160;&#160;</td>
														<td class="font_settings font_size_9">
															<table cellspacing="0" class="max_width border_left border_right">
																<tr>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;">
																		<xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 1, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 1, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;">
																		<xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 2, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 2, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;">
																		<xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 3, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 3, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;">
																		<xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 4, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 4, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;">
																		<xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 5, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 5, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;">
																		<xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 6, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 6, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;">
																		<xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 7, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 7, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;">
																		<xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 8, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 8, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;">
																		<xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 9, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 9, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;">
																		<xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 10, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 10, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;">
																		<xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 11, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 11, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;">
																		<xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 12, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 12, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;">
																		<xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 13, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 13, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;">
																		<xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 14, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 14, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;">
																		<xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 15, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 15, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;">
																		<xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 16, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 16, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;">
																		<xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 17, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 17, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;">
																		<xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 18, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 18, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;">
																		<xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 19, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 19, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;">
																		<xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 20, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 20, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;">
																		<xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 21, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 21, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;">
																		<xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 22, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 22, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;">
																		<xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 23, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 23, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;">
																		<xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 24, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 24, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;">
																		<xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 25, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 25, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;">
																		<xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 26, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 26, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;">
																		<xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 27, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 27, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;">
																		<xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 28, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 28, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose>
																	</td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;"><xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 29, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 29, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose></td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;"><xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 30, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 30, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose></td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;"><xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 31, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 31, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose></td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;"><xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 32, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 32, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose></td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;"><xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 33, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 33, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose></td>
																</tr>
															</table>
														</td>
													</tr>
													<tr>
														<td class="font_family_serif align_v_top align_center_text oneline font_size_6" colspan="2"  style="line-height: 0.9;text-align: left;">
						(назначение&#160;платежа)</td>
													</tr>
													<tr>
														<td style="padding-left: 7mm;" colspan="2">
															<table cellspacing="0" class="max_width border_left border_right">
																<tr>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;"><xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 34, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 34, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose></td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;"><xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 35, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 35, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose></td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;"><xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 36, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 36, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose></td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;"><xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 37, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 37, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose></td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;"><xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 38, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 38, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose></td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;"><xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 39, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 39, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose></td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;"><xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 40, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 40, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose></td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;"><xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 41, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 41, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose></td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;"><xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 42, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 42, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose></td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;"><xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 43, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 43, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose></td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;"><xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 44, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 44, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose></td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;"><xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 45, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 45, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose></td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;"><xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 46, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 46, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose></td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;"><xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 47, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 47, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose></td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;"><xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 48, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 48, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose></td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;"><xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 49, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 49, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose></td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;"><xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 50, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 50, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose></td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;"><xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 51, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 51, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose></td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;"><xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 52, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 52, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose></td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;"><xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 53, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 53, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose></td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;"><xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 54, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 54, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose></td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;"><xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 55, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 55, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose></td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;"><xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 56, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 56, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose></td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;"><xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 57, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 57, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose></td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;"><xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 58, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 58, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose></td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;"><xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 59, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 59, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose></td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;"><xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 60, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 60, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose></td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;"><xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 61, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 61, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose></td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;"><xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 62, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 62, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose></td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;"><xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 63, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 63, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose></td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;"><xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 64, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 64, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose></td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;"><xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 65, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 65, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose></td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;"><xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 66, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 66, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose></td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;"><xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 67, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 67, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose></td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;"><xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 68, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 68, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose></td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;"><xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 69, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 69, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose></td>
																	<td class="align_v_bottom tiny_size">
																		<div class="border_right" style="width: 0; height: 1.5mm;"/>
																	</td>
																	<td class="font_settings font_size_9" style="width: 2%; border: none;"><xsl:choose>
																		  <xsl:when test="substring(shop_order/description, 70, 1)=''">
																			&#160;
																		  </xsl:when>
																		  <xsl:otherwise>
																			<xsl:value-of select="substring(shop_order/description, 70, 1)"/>
																		  </xsl:otherwise>
																		</xsl:choose></td>
																</tr>
															</table>
														</td>
													</tr>
												</table>
											</td>
										</tr>

										<tr>
											<td style="padding: 0 2pt 0 2pt;">
												<table class="max_width" cellspacing="0">
													<tr>
														<td class="border_left border_top border_right border_bottom" style="padding: 2mm 1mm 0 1mm;">
															<table class="max_width" cellspacing="0">
																<tr>
																	<td class="font_family_serif oneline tiny_width align_v_bottom font_size_8 line_height_1">Предъявлен&#160;</td>
																	<td class="font_settings font_size_8" style="width: 30%;">
						&#160;</td>
																	<td class="font_family_serif oneline tiny_width align_v_bottom font_size_8 line_height_1">&#160;Серия&#160;</td>
																	<td class="font_settings font_size_8" style="width: 15%;">
						&#160;</td>
																	<td class="font_family_serif oneline tiny_width align_v_bottom font_size_8 line_height_1">&#160;&#8470;&#160;</td>
																	<td class="font_settings font_size_8" style="width: 20%;">
						&#160;</td>
																	<td class="font_family_serif oneline tiny_width align_v_bottom font_size_8 line_height_1">&#160;выдан&#160;</td>
																	<td class="font_settings font_size_8 width_4">
						&#160;</td>
																	<td class="font_family_serif oneline tiny_width align_v_bottom font_size_8 line_height_1">.</td>
																	<td class="font_settings font_size_8 width_4">
						&#160;</td>
																	<td class="font_family_serif oneline tiny_width align_v_bottom font_size_8 line_height_1">20</td>
																	<td class="font_settings font_size_8 width_4">
						&#160;</td>
																	<td class="font_family_serif oneline tiny_width align_v_bottom font_size_8 line_height_1">г.</td>
																</tr>
																<tr>
																	<td/>
																	<td class="font_family_serif align_v_top align_center_text oneline font_size_6" style="line-height: 0.9;">(наименование документа)</td>
																</tr>
																<tr>
																	<td class="font_settings font_size_8" colspan="13">
						&#160;				</td>
																</tr>
																<tr>
																	<td class="font_family_serif align_v_top align_center_text oneline font_size_6" style="line-height: 0.9;" colspan="13">(наименование учреждения)</td>
																</tr>
															</table>
														</td>
													</tr>
													<tr>
														<td class="border_left border_right border_bottom" style="padding: 0 1mm 1pt 1mm;">
															<div class="font_family_serif oneline tiny_width align_v_bottom font_size_7 font_weight_bold font_style_italic font_family_serif line_height_1">
																<u>Для нерезидентов России</u>
															</div>
															<table class="max_width" cellspacing="0">
																<tr>
																	<td class="font_family_serif oneline tiny_width align_v_bottom font_size_8 line_height_1">Предъявлен&#160;</td>
																	<td class="font_settings font_size_8" style="width: 30%;">
																		<span class="oneline"></span>
																	</td>
																	<td class="font_family_serif oneline tiny_width align_v_bottom font_size_8 line_height_1">&#160;Серия&#160;</td>
																	<td class="font_settings font_size_8" style="width: 15%;">
																		<span class="oneline"></span>
																	</td>
																	<td class="font_family_serif oneline tiny_width align_v_bottom font_size_8 line_height_1">&#160;&#8470;&#160;</td>
																	<td class="font_settings font_size_8" style="width: 20%;">
																		<span class="oneline"></span>
																	</td>
																	<td class="font_family_serif oneline tiny_width align_v_bottom font_size_8 line_height_1">&#160;выдан&#160;</td>
																	<td class="font_settings font_size_8 width_4">
						&#160;</td>
																	<td class="font_family_serif oneline tiny_width align_v_bottom font_size_8 line_height_1">.</td>
																	<td class="font_settings font_size_8 width_4">
						&#160;</td>
																	<td class="font_family_serif oneline tiny_width align_v_bottom font_size_8 line_height_1">20</td>
																	<td class="font_settings font_size_8 width_4">
						&#160;</td>
																	<td class="font_family_serif oneline tiny_width align_v_bottom font_size_8 line_height_1">г.</td>
																</tr>
																<tr>
																	<td/>
																	<td class="font_family_serif align_v_top align_center_text oneline font_size_6" style="line-height: 0.9;">(наименование документа)</td>
																</tr>
															</table>
															<table cellspacing="0">
																<tr>
																	<td class="font_family_serif oneline tiny_width align_v_bottom font_size_8 line_height_1">Дата&#160;срока&#160;пребывания&#160;с&#160;</td>
																	<td class="font_settings font_size_8" style="width: 8mm;">
						&#160;</td>
																	<td class="font_family_serif oneline tiny_width align_v_bottom font_size_8 line_height_1">.</td>
																	<td class="font_settings font_size_8" style="width: 8mm;">
						&#160;</td>
																	<td class="font_family_serif oneline tiny_width align_v_bottom font_size_8 line_height_1">20</td>
																	<td class="font_settings font_size_8" style="width: 8mm;">
						&#160;</td>
																	<td class="font_family_serif oneline tiny_width align_v_bottom font_size_8 line_height_1">г.,&#160;по</td>
																	<td class="font_settings font_size_8" style="width: 8mm;">
						&#160;</td>
																	<td class="font_family_serif oneline tiny_width align_v_bottom font_size_8 line_height_1">.</td>
																	<td class="font_settings font_size_8" style="width: 8mm;">
						&#160;</td>
																	<td class="font_family_serif oneline tiny_width align_v_bottom font_size_8 line_height_1">20</td>
																	<td class="font_settings font_size_8" style="width: 8mm;">
						&#160;</td>
																	<td class="font_family_serif oneline tiny_width align_v_bottom font_size_8 line_height_1">г.</td>
																</tr>
															</table>
														</td>
													</tr>
												</table>
											</td>
										</tr>

										<tr>
											<td style="padding: 2mm 1mm 1pt 3mm;">
												<table cellspacing="0">
													<tr>
														<td class="font_family_serif oneline tiny_width align_v_bottom font_size_8 font_weight_bold font_family_serif font_style_italic line_height_1">
															<u>Гражданство:</u>&#160;</td>
														<td class="font_settings font_size_8" style="width: 40mm; text-align: left; border: none;">
															<span class="oneline"></span>
														</td>
														<td class="font_family_serif oneline tiny_width align_v_bottom font_size_8 font_weight_bold font_family_serif font_style_italic line_height_1">&#160;<u>Подпись&#160;отправителя</u>
														</td>
													</tr>
												</table>
											</td>
										</tr>


									</table>
								</td>
							</tr>

							<tr>
								<td style="padding: 0 3mm 5mm 70mm;">
									<table class="max_width" cellspacing="0">
										<tr>
											<td class="font_size_9 font_settings" style="width: 25mm; line-height: 2;">&#160;</td>
										</tr>
										<tr>
											<td class="font_size_9 font_settings" style="width: 25mm;">&#160;</td>
											<td class="font_family_serif oneline tiny_width align_v_bottom font_size_9 font_weight_bold font_family_serif line_height_1"  style="width: 3mm;">&#160;</td>
											<td class="font_size_9 font_settings" style="width: 25mm; line-height: 2;">&#160;</td>
										</tr>
										<tr>
											<td class="font_family_serif align_v_top align_center_text oneline font_size_7" style="line-height: 0.9;">(шифр и подпись)</td>
											<td/>
											<td class="font_family_serif align_v_top align_center_text oneline font_size_7" style="line-height: 0.9;">(подпись оператора)</td>
										</tr>

									</table>

								</td>
							</tr>
						</table>
					</td>
					<td class="font_size_8" style="padding-top: 20mm;">
						<img width="11" height="134" src="/hostcmsfiles/images/post_4.png" />
					</td>
				</tr>
			</table>
			<div style="page-break-before: always;" class="topmargin"></div>
			<table cellspacing="0" class="data">
				<tr>
					<td/>

					<td>
						<table class="max_width max_height" cellspacing="0">
							<tr>
								<td style="height: 38mm;">
									<table style="width: 35mm; height: 30mm;" cellspacing="0">
										<tr>
											<td class="font_family_serif oneline tiny_width align_v_bottom font_size_9 line_height_1">Вторичное&#160;извещение</td>
											<td class="font_size_11 font_weight_bold font_family_serif" style="line-height: 1.1; text-align: center; padding: 3mm 0 0 3mm;"
						rowspan="7">О<br/>П<br/>Л<br/>А<br/>Т<br/>А</td>
										</tr>
										<tr>
											<td>
												<table class="max_width max_height" cellspacing="0">
													<tr>
														<td class="font_family_serif oneline tiny_width align_v_bottom font_size_9 line_height_1">выписано</td>
														<td class="font_settings font_size_9">&#160;</td>
													</tr>
												</table>
											</td>
										</tr>
										<tr>
											<td class="font_family_serif oneline tiny_width align_v_bottom font_size_9 font_weight_bold font_family_serif line_height_1" colspan="2">Плата&#160;за&#160;доставку</td>
										</tr>
										<tr>
											<td class="tiny_height">
												<table class="max_width" cellspacing="0">
													<tr>
														<td class="font_settings font_size_9" style="width: 12mm;">&#160;</td>
														<td class="font_family_serif oneline tiny_width align_v_bottom font_size_9 font_weight_bold font_family_serif line_height_1">&#160;руб.&#160;</td>
														<td class="font_settings font_size_9" style="width: 8mm;">&#160;</td>
														<td class="font_family_serif oneline tiny_width align_v_bottom font_size_9 font_weight_bold font_family_serif line_height_1">&#160;коп.</td>
													</tr>
												</table>
											</td>
										</tr>
										<tr>
											<td class="font_family_serif oneline tiny_width align_v_bottom font_size_9 line_height_1">Подлежит&#160;оплате</td>
										</tr>
										<tr>
											<td class="font_settings font_size_9">&#160;</td>
										</tr>
										<tr>
											<td class="font_family_serif align_v_top align_center_text oneline font_size_7 tiny_height" style="line-height: 0.9;">(подпись)</td>
										</tr>
									</table>
								</td>
							</tr>

							<tr>
								<td class="tiny_height">
									<table style="width: 35mm;" cellspacing="0">
										<tr>
											<td class="font_size_75 font_weight_bold font_family_serif font_style_italic">Обведенное&#160;жирной&#160;чертой<br/>заполняется&#160;адресатом</td>
											<td class="font_size_11 font_weight_bold font_family_serif" style="padding-left: 5mm;">РАСПИСКА&#160;АДРЕСАТА</td>
										</tr>
									</table>
								</td>
							</tr>

							<tr>
								<td style="width: 120mm; height: 105mm; border: black 2.5pt solid; padding: 0 2pt 1pt 2pt;">
									<table class="max_width max_height" cellspacing="0">

										<tr>
											<td style="padding: 0 2pt 0 2pt;">
												<table class="max_width" cellspacing="0">
													<tr>
														<td class="font_family_serif oneline tiny_width align_v_bottom font_size_9 font_weight_bold font_family_serif line_height_1" style="vertical-align: middle; padding-bottom: 10pt;">Сумма&#160;</td>
														<td>
															<table class="max_width" cellspacing="0">
																<tr>
																	<td class="class2">
																		<div class="class3">&#160;</div>
																	</td>
																</tr>
																<tr>
																	<td class="class2">
																		<div class="class3">&#160;</div>
																	</td>
																</tr>
																<tr>
																	<td class="class2">
																		<div class="class3">&#160;</div>
																	</td>
																</tr>
																<tr>
																	<td class="class2">
																		<div class="class3">&#160;</div>
																	</td>
																</tr>
																<tr>
																	<td class="class2">
																		<div class="class3">&#160;</div>
																	</td>
																</tr>
																<tr>
																	<td class="class2">
																		<div class="class3">&#160;</div>
																	</td>
																</tr>
																<tr>
																	<td class="class2">
																		<div class="class3">&#160;</div>
																	</td>
																</tr>
																<tr>
																	<td class="class2">
																		<div class="class3">&#160;</div>
																	</td>
																</tr>
																<tr>
																	<td class="class2">
																		<div class="class3">&#160;</div>
																	</td>
																</tr>
																<tr>
																	<td class="font_family_serif align_v_top align_center_text oneline font_size_7"  style="line-height: 0.9;padding-bottom: 4pt;">
							(рубли прописью, копейки цифрами)</td>
																</tr>
															</table>
														</td>
													</tr>
												</table>
											</td>
										</tr>

										<tr>
											<td style="padding: 1pt 2pt 0 2pt;">
												<table class="max_width" cellspacing="0">
													<tr>
														<td class="font_family_serif oneline tiny_width align_v_bottom font_size_9 font_weight_bold font_family_serif line_height_1">ФИО</td>
														<td class="font_settings font_size_9">&#160;</td>
														<td class="font_family_serif align_right_text oneline tiny_width align_v_bottom font_size_6 font_style_italic font_family_serif border_bottom line_height_1">
						ИНН&#160;при&#160;<br/>его&#160;наличии&#160;</td>
														<td style="width: 30%;">
															<table class="cells" cellspacing="0">
																<tr>
																	<td class="cell width_8">&#160;</td>
																	<td class="cell width_8">&#160;</td>
																	<td class="cell width_8">&#160;</td>
																	<td class="cell width_8">&#160;</td>
																	<td class="cell width_8">&#160;</td>
																	<td class="cell width_8">&#160;</td>
																	<td class="cell width_8">&#160;</td>
																	<td class="cell width_8">&#160;</td>
																	<td class="cell width_8">&#160;</td>
																	<td class="cell width_8">&#160;</td>
																	<td class="cell width_8">&#160;</td>
																	<td class="cell width_8">&#160;</td>
																</tr>
															</table>
														</td>
													</tr>
													<tr>
														<td/>
														<td class="font_family_serif align_v_top align_center_text oneline font_size_6" style="line-height: 0.9;">
						(фамилия, имя, отчество)
														</td>
													</tr>
													<tr>
														<td class="font_settings font_size_9" colspan="4">&#160;</td>
													</tr>
												</table>
											</td>
										</tr>

										<tr>
											<td style="padding: 1pt 2pt 0 2pt;">
												<table class="max_width" cellspacing="0">
													<tr>
														<td class="font_family_serif oneline tiny_width align_v_bottom font_size_9 font_weight_bold font_family_serif line_height_1">Получил&#160;&quot;&#160;</td>
														<td class="font_settings font_size_9" style="width: 9mm;">&#160;</td>
														<td class="font_family_serif oneline tiny_width align_v_bottom font_size_9 font_weight_bold font_family_serif line_height_1">&#160;&quot;&#160;</td>
														<td class="font_settings font_size_9" style="width: 32mm;">&#160;</td>
														<td class="font_family_serif oneline tiny_width align_v_bottom font_size_9 font_weight_bold font_family_serif line_height_1">&#160;20&#160;</td>
														<td class="font_settings font_size_9" style="width: 5mm;">&#160;</td>
														<td class="font_family_serif oneline tiny_width align_v_bottom font_size_9 font_weight_bold font_family_serif line_height_1" style="padding-right: 8mm;">&#160;г.</td>
														<td class="font_settings font_size_9">&#160;</td>
													</tr>
													<tr>
														<td/>
														<td/>
														<td/>
														<td class="font_family_serif align_v_top align_center_text oneline font_size_7" style="line-height: 0.9;">(дата)</td>
														<td/>
														<td/>
														<td/>
														<td class="font_family_serif align_v_top align_center_text oneline font_size_7"  style="line-height: 0.9;padding-bottom: 4pt;">(подпись адресата)</td>
													</tr>
												</table>
											</td>
										</tr>

										<tr>
											<td class="tiny_height" style="padding: 0 2pt 0 2pt;">
												<table class="max_width" cellspacing="0">
													<tr>
														<td class="border_left border_top border_right border_bottom" style="padding: 2mm 1mm 0 1mm;">
															<table class="max_width" cellspacing="0">
																<tr>
																	<td class="font_family_serif oneline tiny_width align_v_bottom font_size_8 line_height_1">Предъявлен&#160;</td>
																	<td class="font_settings font_size_8" style="width: 30%;">&#160;</td>
																	<td class="font_family_serif oneline tiny_width align_v_bottom font_size_8 line_height_1">&#160;Серия&#160;</td>
																	<td class="font_settings font_size_8" style="width: 15%;">&#160;</td>
																	<td class="font_family_serif oneline tiny_width align_v_bottom font_size_8 line_height_1">&#160;&#8470;&#160;</td>
																	<td class="font_settings font_size_8" style="width: 20%;">&#160;</td>
																	<td class="font_family_serif oneline tiny_width align_v_bottom font_size_8 line_height_1">&#160;выдан&#160;</td>
																	<td class="font_settings font_size_8 width_4">&#160;</td>
																	<td class="font_family_serif oneline tiny_width align_v_bottom font_size_8 line_height_1">.</td>
																	<td class="font_settings font_size_8 width_4">&#160;</td>
																	<td class="font_family_serif oneline tiny_width align_v_bottom font_size_8 line_height_1">20</td>
																	<td class="font_settings font_size_8 width_4">&#160;</td>
																	<td class="font_family_serif oneline tiny_width align_v_bottom font_size_8 line_height_1">г.</td>
																</tr>
																<tr>
																	<td/>
																	<td class="font_family_serif align_v_top align_center_text oneline font_size_6" style="line-height: 0.9;">(наименование документа)</td>
																</tr>
																<tr>
																	<td class="font_settings font_size_8" colspan="13">&#160;</td>
																</tr>
																<tr>
																	<td class="font_family_serif align_v_top align_center_text oneline font_size_6" style="line-height: 0.9;" colspan="13">(наименование учреждения)</td>
																</tr>
															</table>
														</td>
													</tr>
													<tr>
														<td class="border_left border_right border_bottom" style="padding: 0 1mm 1pt 1mm;">
															<div class="field font_size_7 font_weight_bold font_style_italic font_family_serif line_height_1">
																<u>Для нерезидентов России</u>
															</div>
															<table class="max_width" cellspacing="0">
																<tr>
																	<td class="field font_size_8 line_height_1">Предъявлен&#160;</td>
																	<td class="font_settings font_size_8" style="width: 30%;">&#160;</td>
																	<td class="field font_size_8 line_height_1">&#160;Серия&#160;</td>
																	<td class="font_settings font_size_8" style="width: 15%;">&#160;</td>
																	<td class="field font_size_8 line_height_1">&#160;&#8470;&#160;</td>
																	<td class="font_settings font_size_8" style="width: 20%;">&#160;</td>
																	<td class="field font_size_8 line_height_1">&#160;выдан&#160;</td>
																	<td class="font_settings font_size_8 width_4">&#160;</td>
																	<td class="field font_size_8 line_height_1">.</td>
																	<td class="font_settings font_size_8 width_4">&#160;</td>
																	<td class="field font_size_8 line_height_1">20</td>
																	<td class="font_settings font_size_8 width_4">&#160;</td>
																	<td class="field font_size_8 line_height_1">г.</td>
																</tr>
																<tr>
																	<td/>
																	<td class="font_family_serif align_v_top align_center_text oneline font_size_6" style="line-height: 0.9;">(наименование документа)</td>
																</tr>
															</table>
															<table cellspacing="0">
																<tr>
																	<td class="field font_size_8 line_height_1">Дата&#160;срока&#160;пребывания&#160;с&#160;</td>
																	<td class="font_settings font_size_8" style="width: 8mm;">&#160;</td>
																	<td class="field font_size_8 line_height_1">.</td>
																	<td class="font_settings font_size_8" style="width: 8mm;">&#160;</td>
																	<td class="field font_size_8 line_height_1">20</td>
																	<td class="font_settings font_size_8" style="width: 8mm;">&#160;</td>
																	<td class="field font_size_8 line_height_1">г.,&#160;по</td>
																	<td class="font_settings font_size_8" style="width: 8mm;">&#160;</td>
																	<td class="field font_size_8 line_height_1">.</td>
																	<td class="font_settings font_size_8" style="width: 8mm;">&#160;</td>
																	<td class="field font_size_8 line_height_1">20</td>
																	<td class="font_settings font_size_8" style="width: 8mm;">&#160;</td>
																	<td class="field font_size_8 line_height_1">г.</td>
																</tr>
															</table>
														</td>
													</tr>
												</table>
											</td>
										</tr>

										<tr>
											<td style="padding: 2mm 1mm 1pt 2mm;">
												<table cellspacing="0">
													<tr>
														<td class="field font_size_8 font_weight_bold font_family_serif font_style_italic border_bottom line_height_1">Гражданство:</td>
														<td class="font_settings font_size_8" style="width: 30mm; text-align: left;">&#160;</td>
													</tr>
												</table>
											</td>
										</tr>

										<tr>
											<td class="font_size_7 font_weight_bold font_style_italic font_family_serif" style="padding: 0 0 2pt 2mm;">
					Укажите адрес места жительства (регистрации) или места пребывания адресата.
											</td>
										</tr>
										<tr>
											<td class="font_settings font_size_9" style="padding: 2pt;">&#160;</td>
										</tr>
										<tr>
											<td class="font_settings font_size_9" style="padding: 2pt;">&#160;</td>
										</tr>

										<tr>
											<td style="padding: 2pt 0 5pt 0;">
												<table class="max_width max_height border_top_bold border_right_bold border_bottom_bold border_left_bold" cellspacing="0">
													<tr>
														<td class="font_size_75 font_weight_bold font_family_serif font_style_italic" style="padding-left: 2pt;">
						Заполняется при выплате перевода в адрес юридического лица
														</td>
													</tr>
													<tr>
														<td style="padding: 0 2pt 1pt 2pt;">
															<table class="max_width" cellspacing="0">
																<tr>
																	<td class="field font_size_9 font_weight_bold font_family_serif tiny_width line_height_1">Получатель:</td>
																	<td class="font_settings font_size_8">&#160;</td>
																</tr>
															</table>
														</td>
													</tr>
													<tr>
														<td style="padding: 0 2pt 1mm 2pt;">
															<table class="max_width" cellspacing="0">
																<tr>
																	<td class="field font_size_9 font_weight_bold font_family_serif font_style_italic line_height_1">ИНН:</td>
																	<td style="width: 30%;">
																		<table class="cells" cellspacing="0">
																			<tr>
																				<td class="cell" style="width: 10%;">&#160;</td>
																				<td class="cell" style="width: 10%;">&#160;</td>
																				<td class="cell" style="width: 10%;">&#160;</td>
																				<td class="cell" style="width: 10%;">&#160;</td>
																				<td class="cell" style="width: 10%;">&#160;</td>
																				<td class="cell" style="width: 10%;">&#160;</td>
																				<td class="cell" style="width: 10%;">&#160;</td>
																				<td class="cell" style="width: 10%;">&#160;</td>
																				<td class="cell" style="width: 10%;">&#160;</td>
																				<td class="cell" style="width: 10%;">&#160;</td>
																			</tr>
																		</table>
																	</td>
																	<td class="field font_size_9 font_weight_bold font_family_serif font_style_italic line_height_1"  style="padding-left: 8mm;">&#160;ОГРН:</td>
																	<td style="width: 60%; padding-right: 15mm;">
																		<table class="cells" cellspacing="0">
																			<tr>
																				<td class="cell width_6">&#160;</td>
																				<td class="cell width_6">&#160;</td>
																				<td class="cell width_6">&#160;</td>
																				<td class="cell width_6">&#160;</td>
																				<td class="cell width_6">&#160;</td>
																				<td class="cell width_6">&#160;</td>
																				<td class="cell width_6">&#160;</td>
																				<td class="cell width_6">&#160;</td>
																				<td class="cell width_6">&#160;</td>
																				<td class="cell width_6">&#160;</td>
																				<td class="cell width_6">&#160;</td>
																				<td class="cell width_6">&#160;</td>
																				<td class="cell width_6">&#160;</td>
																				<td class="cell width_6">&#160;</td>
																				<td class="cell width_6">&#160;</td>
																			</tr>
																		</table>
																	</td>
																</tr>
															</table>
														</td>
													</tr>
													<tr>
														<td style="padding: 0 2pt 0 2pt;">
															<table class="max_width" cellspacing="0">
																<tr>
																	<td class="font_settings font_size_9">&#160;</td>
																</tr>
																<tr>
																	<td class="font_family_serif align_v_top align_center_text oneline font_size_6" style="line-height: 0.9;">
							(адрес местоположения по месту государственной регистрации)
																	</td>
																</tr>
																<tr>
																	<td class="font_settings font_size_9">&#160;</td>
																</tr>
																<tr>
																	<td class="font_family_serif align_v_top align_center_text oneline font_size_6" style="line-height: 0.9;">&#160;</td>
																</tr>
																<tr>
																	<td class="font_settings font_size_9">&#160;</td>
																</tr>
																<tr>
																	<td class="font_family_serif align_v_top align_center_text oneline font_size_6" style="line-height: 0.9;">
							(фактический адрес, указать при несовпадении
							с местом государственной регистрации)
																	</td>
																</tr>
															</table>
														</td>
													</tr>

												</table>
											</td>
										</tr>

									</table>
								</td>
							</tr>

							<tr>
								<td>
									<table class="max_width" cellspacing="0">
										<tr>
											<td class="tiny_width" style="padding: 2pt 2pt 4mm 2pt;">
												<table style="width: 90mm; height: 26mm;" cellspacing="0">
													<tr>
														<td class="field font_size_9 border_bottom line_height_1">Оплатил</td>
														<td class="font_settings font_size_9" style="width: 90mm;">&#160;</td>
													</tr>
													<tr>
														<td class="font_family_serif align_v_top align_center_text oneline font_size_6"  style="line-height: 0.9;font-size: 9pt;">(перечислено)</td> 
														<td class="font_family_serif align_v_top align_center_text oneline font_size_7" style="line-height: 0.9;">(должность, подпись)</td>
													</tr> 
													<tr>
														<td class="field font_size_9 font_weight_bold font_family_serif line_height_1" colspan="2">
						Отметки&#160;о&#160;досылке,&#160;возвращении&#160;и&#160;причинах&#160;неоплаты				</td>
													</tr>
													<tr>
														<td class="font_settings font_size_9" colspan="2">&#160;</td>
													</tr>
													<tr>
														<td class="font_settings font_size_9" colspan="2">&#160;</td>
													</tr>
													<tr>
														<td class="font_settings font_size_9" colspan="2">&#160;</td>
													</tr>
												</table>
											</td>
											<td class="align_center_text font_size_7 font_family_serif oneline" style="line-height: 1.1; padding-bottom: 3mm;">
												<div class="border_top border_bottom border_left border_right align_center"
						style="width: 17mm; height: 17mm; margin-bottom: 2pt;">&#160;</div>
					(оттиск КПШ ОПС<br/>места получ.<br/>или дня перечисления)
											</td>
										</tr>
									</table>
								</td>
							</tr>

						</table>
					</td>

					<td class="align_right_text">
						<span class="font_size_8 position_relative left_5">
							<img width="9" height="58" src="/hostcmsfiles/images/post_2.png" />
						</span>
					</td>

					<td class="align_v_top" style="border-left: black 1pt dotted; padding: 3mm;">
						<div class="font_size_8" style="float: left; margin-bottom: 5mm;">
							<img width="55" height="60" src="/hostcmsfiles/images/post_1.png" />
						</div>
						<center>
							<span class="font_size_11 font_weight_bold font_family_serif" style="line-height: 1.6;">&#160;<br/>
			ТАЛОН<br/>
							</span>
							<span class="font_size_9 font_weight_bold font_family_serif">к почтовому переводу</span>
							<table cellspacing="0" style="margin-top: 3mm;">
								<tr>
									<td class="field font_size_10 font_weight_bold font_family_serif line_height_1">
										<span class="position_relative" style="bottom: -1pt;">На&#160;</span>
									</td>
									<td class="font_settings font_size_9" style="width: 12mm;"><xsl:value-of select="floor(shop_order/total_amount)"/></td>
									<td class="field font_size_10 font_weight_bold font_family_serif line_height_1">
										<span class="position_relative" style="bottom: -1pt;">&#160;руб.&#160;</span>
									</td>
									<td class="font_settings font_size_9" style="width: 8mm;"><xsl:value-of select="format-number((shop_order/total_amount * 100) mod 100 , '00')"/></td>
									<td class="field font_size_10 font_weight_bold font_family_serif line_height_1">
										<span class="position_relative" style="bottom: -1pt;">&#160;коп.</span>
									</td>
								</tr>
							</table>
						</center>
						<table class="max_width" cellspacing="0">
							<tr>
								<td class="field font_size_9 font_weight_bold font_family_serif line_height_1">От&#160;кого&#160;</td>
								<td class="font_settings font_size_9 height_65" style="width: 60mm;">
									<span class="oneline"><xsl:value-of select="shop_order/surname"/>&#160;<xsl:value-of select="shop_order/name"/></span>
								</td>
							</tr>
							<tr>
								<td class="font_settings font_size_9 height_65" colspan="2">
									<span class="oneline"><xsl:value-of select="shop_order/patronymic"/></span>
								</td>
							</tr>
							<tr>
								<td class="font_settings font_size_9 height_65" colspan="2">&#160;</td>
							</tr>
						</table>
						<table class="max_width" cellspacing="0">
							<tr>
								<td class="field font_size_9 font_weight_bold font_family_serif tiny_width line_height_1">Адрес&#160;отправителя&#160;</td>
								<td class="font_settings font_size_9 height_65">
									<span class="oneline"><xsl:value-of select="shop_order/postcode"/>&#160;</span>
								</td>
							</tr>
							<tr>
								<td class="font_settings font_size_9 height_65" colspan="2">
									<span class="oneline"><xsl:value-of select="shop_order/address"/></span>
								</td>
							</tr>
							<tr>
								<td class="font_settings font_size_9 height_65" colspan="2">&#160;</td>
							</tr>
							<tr>
								<td class="font_settings font_size_9 height_65" colspan="2">&#160;</td>
							</tr>
							<tr>
								<td class="font_settings font_size_9 height_65" colspan="2">&#160;</td>
							</tr>
							<tr>
								<td class="font_settings font_size_9 height_65" colspan="2">&#160;</td>
							</tr>
						</table>
						<table class="max_width" cellspacing="0">
							<tr>
								<td class="field font_size_9 font_weight_bold font_family_serif tiny_width line_height_1">Сообщение&#160;</td>
								<td class="font_settings font_size_9 height_65">
									<span class="oneline"><xsl:value-of select="substring(shop_order/description, 1, 25)"/></span>
								</td>
							</tr>
							<tr>
								<td class="font_settings font_size_9 height_65" colspan="2"><xsl:value-of select="substring(shop_order/description, 25)"/>&#160;</td>
							</tr>
						</table>
					</td>

				</tr>
				<tr>
					<td style="width: 3mm;" class="tiny_height">
						<div style="width: 3mm;" class="class1"/>
					</td>
					<td style="width: 124mm;" class="tiny_height">
						<div style="width: 124mm;" class="class1"/>
					</td>
					<td style="width: 3mm;" class="tiny_height">
						<div style="width: 3mm;" class="class1"/>
					</td>
					<td style="width: 65mm;" class="tiny_height">
						<div style="width: 65mm;" class="class1"/>
					</td>
				</tr>
			</table>

</xsl:template>

</xsl:stylesheet>