<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE xsl:stylesheet>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output xmlns="http://www.w3.org/TR/xhtml1/strict" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" encoding="utf-8" indent="yes" method="html" omit-xml-declaration="no" version="1.0" media-type="text/xml"/>
	
	<xsl:template match="/site">
		<div class="uk-margin-auto-vertical uk-margin-auto-vertical uk-width-1-1">
		<!--<h3 class="uk-panel-title"><i class="uk-icon-home uk-icon-small"></i> Главное  меню</h3>-->
			<!--<ul class="uk-nav uk-nav-offcanvas uk-nav-parent-icon level-1" id="offcanvas_main_menu" data-uk-nav="">-->
				
				
				<div class="" id="offcanvas_main_menu">
					
					<div class="uk-margin-auto-vertical uk-width-1-1">
						<div class="uk-child-width-1-1 uk-grid uk-grid-stack" uk-grid="">
							<div class="uk-first-column">
								<div class="uk-panel">
									
									<ul class="uk-nav-default uk-nav-center uk-nav-parent-icon uk-nav-primary" uk-nav="">
										<!-- Выбираем узлы структуры первого уровня -->
										<xsl:apply-templates select="structure[show=1]"/>
										<li class="uk-nav-divider"></li>
								<li><a href="/shop/"><span class="uk-margin-small-right" uk-icon="icon: cart"></span> Каталог продуции</a></li>
										
										
									</ul>
									
								</div>
							</div>
						</div>
					</div>
					
				</div>
				<script language="JavaScript">
					<xsl:comment>
						/*$(document).ready(function() {
						$('#offcanvas_main_menu li.uk-active').parentsUntil('#offcanvas_main_menu', 'li.uk-parent').addClass('uk-active uk-open').find('> div').css('height', 'auto');
						});*/
					</xsl:comment>
				</script>
			</div>
		</xsl:template>
		
		<xsl:template match="structure">
			<xsl:variable name="current_structure_id" select="/site/current_structure_id"/>
			<li>
				<xsl:if test="position() = last()">
					<xsl:attribute name="class">last</xsl:attribute>
				</xsl:if>
				<xsl:if test="@id=$current_structure_id">
					<xsl:attribute name="class">uk-active</xsl:attribute>
				</xsl:if>
				
				
				
				<xsl:if test="count(structure[show=1]) > 0">
					<xsl:attribute name="class">uk-parent</xsl:attribute>
					
				</xsl:if>
				
				<!-- Показывать ссылку, или нет -->
				<xsl:choose>
					<xsl:when test="show = 1">
						<!-- Определяем адрес ссылки -->
						<xsl:variable name="link">
							<xsl:choose>
								<!-- Если внешняя ссылка -->
								<xsl:when test="url != ''">
									<xsl:value-of disable-output-escaping="yes" select="url"/>
								</xsl:when>
								<!-- Иначе если внутренняя ссылка -->
								<xsl:otherwise>
									<xsl:value-of disable-output-escaping="yes" select="link"/>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:variable>
						<!-- Ссылка на пункт меню -->
						
						
						<xsl:if test="count(structure[show=1]) = 0">
							<a href="http://snab-lift.com.ua{$link}" title="{name}"  hostcms:id="{@id}" hostcms:field="name" hostcms:entity="structure" ><xsl:value-of disable-output-escaping="yes" select="name"/></a>
						</xsl:if>
						
						
						<xsl:if test="count(structure[show=1]) > 0">
							<a href="#" title="{name}">
								<xsl:value-of disable-output-escaping="yes" select="name"/>
							</a>
							
							<ul class="uk-nav-sub">
								<xsl:variable name="posit_var" select="position()"/>
								<xsl:apply-templates select="structure[show=1]">
									<xsl:with-param name="posit" select="$posit_var"/>
								</xsl:apply-templates>
							</ul>
							
						</xsl:if>
					</xsl:when>
					<!-- Если не показывать ссылку - выводим просто имя ссылки -->
					<xsl:otherwise>
						<xsl:value-of disable-output-escaping="yes" select="name"/>
					</xsl:otherwise>
				</xsl:choose>
			</li>
		</xsl:template>
	</xsl:stylesheet>