<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE xsl:stylesheet>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:hostcms="http://www.hostcms.ru/"
	exclude-result-prefixes="hostcms">
	<xsl:output xmlns="http://www.w3.org/TR/xhtml1/strict" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" encoding="utf-8" indent="yes" method="html" omit-xml-declaration="no" version="1.0" media-type="text/xml" />

	<!-- ФинансыОтобразитьФорму -->

	<xsl:template match="/">
		<script src="http://api-maps.yandex.ru/2.1/?lang=ru_RU" type="text/javascript"></script>
		<script type="text/javascript">
			ymaps.ready(init);

			function init() {
				var myMap = new ymaps.Map("yandexMap", {
						center: [55.684758, 37.738521],
						zoom: 15
					}, {
						searchControlProvider: 'yandex#search'
					});

				myMap.geoObjects
					.add(new ymaps.Placemark([55.684758, 37.738521], {
						balloonContent: "Наша компания"
					}, {
						preset: 'islands#icon',
						iconColor: "#ff006e"
					}));
			}
		</script>

		<section class="main-contacts">
			<div class="container">
				<div class="row">
					<div class="col-xs-12 col-md-6">
						<xsl:apply-templates select="form" />
					</div>
					<div class="col-xs-12 col-md-6">
						<div id="yandexMap"></div>
					</div>
				</div>
			</div>
		</section>
	</xsl:template>

	<xsl:template match="/form">
		<xsl:choose>
			<xsl:when test="success/node() and success = 1">
				<h3>Спасибо! Запрос получен, в ближайшее время Вам будет дан ответ.</h3>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<!-- Выводим ошибку (error), если она была передана через внешний параметр -->
					<xsl:when test="error != ''">
						<div id="error">
							<xsl:value-of disable-output-escaping="yes" select="error" />
						</div>
					</xsl:when>
					<xsl:when test="errorId/node()">
						<div id="error">
							<xsl:choose>
								<xsl:when test="errorId = 0">
									Вы неверно ввели число подтверждения отправки формы!
								</xsl:when>
								<xsl:when test="errorId = 1">
									Заполните все обязательные поля!
								</xsl:when>
								<xsl:when test="errorId = 2">
									Прошло слишком мало времени с момента последней отправки Вами формы!
								</xsl:when>
							</xsl:choose>
						</div>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of disable-output-escaping="yes" select="description" />
					</xsl:otherwise>
				</xsl:choose>

				<form name="form{@id}" id="form{@id}" class="contacts validate" action="./" method="post" enctype="multipart/form-data">
					<!-- Вывод списка полей формы 0-го уровня -->
					<xsl:apply-templates select="form_field" />

					<button value="submit" name="{button_name}" type="submit" class="btn btn-lightred">Отправить</button>
				</form>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="form_field">
		<!-- Не скрытое поле и не надпись -->
		<xsl:if test="type != 7 and type != 8">
			<div class="form-group">
				<!-- Текстовые поля -->
				<xsl:if test="type = 0 or type = 1 or type = 2">
					<input class="form-control " type="text" name="{name}" value="{value}" size="{size}" placeholder="{caption}">
						<xsl:choose>
							<!-- Поле для ввода пароля -->
							<xsl:when test="type = 1">
								<xsl:attribute name="type">password</xsl:attribute>
							</xsl:when>
							<!-- Поле загрузки файла -->
							<xsl:when test="type = 2">
								<xsl:attribute name="type">file</xsl:attribute>
							</xsl:when>
							<!-- Текстовое поле -->
							<xsl:otherwise>
								<xsl:attribute name="type">text</xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:if test="obligatory = 1">
							<xsl:attribute name="class">form-control required</xsl:attribute>
						</xsl:if>
					</input>
				</xsl:if>

				<!-- Textarea -->
				<xsl:if test="type = 5">
					<textarea class="form-control" name="{name}" cols="{cols}" rows="{rows}" wrap="off" placeholder="{caption}">
						<xsl:if test="obligatory = 1">
							<xsl:attribute name="class">form-control required</xsl:attribute>
						</xsl:if>
						<xsl:value-of select="value" />
					</textarea>
				</xsl:if>
			</div>
		</xsl:if>

		<!-- скрытое поле -->
		<xsl:if test="type = 7">
			<input type="hidden" name="{name}" value="{value}" />
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>