<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE xsl:stylesheet>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:hostcms="http://www.hostcms.ru/"
	exclude-result-prefixes="hostcms">

	<xsl:output xmlns="http://www.w3.org/TR/xhtml1/strict" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" encoding="utf-8" indent="yes" method="html" omit-xml-declaration="no" version="1.0" media-type="text/xml"/>

	<!-- ФинансыНовость -->
	
	<xsl:template match="/">
		<xsl:apply-templates select="/informationsystem/informationsystem_item"/>
	</xsl:template>	

	<xsl:template match="informationsystem_item">
		<section class="main-home">
			<div class="container">
				<header>				
					<h2><xsl:value-of select="name"/></h2>
					<div class="news-date">
						<xsl:call-template name="date_to_str">
							<xsl:with-param name="date" select="date" />
						</xsl:call-template>
					</div>						
					<div class="separator-small"></div>					
					<div class="sub-heading"><xsl:value-of disable-output-escaping="yes" select="description"/></div>				
				</header>
			</div>
		</section>
	</xsl:template>

	<!-- Вывод даты с месяцем на русском -->
	<xsl:template name="date_to_str">
		<xsl:param name="date" select="date"/>

		<xsl:variable select="substring-after($date, '.')" name="month_postfixDate" />
		<xsl:variable select="substring-before($month_postfixDate, '.')" name="month" />

		<xsl:value-of select="substring-before($date, '.')"/>&#160;<xsl:choose>
			<xsl:when test="$month = 1">января</xsl:when>
			<xsl:when test="$month = 2">февраля</xsl:when>
			<xsl:when test="$month = 3">марта</xsl:when>
			<xsl:when test="$month = 4">апреля</xsl:when>
			<xsl:when test="$month = 5">мая</xsl:when>
			<xsl:when test="$month = 6">июня</xsl:when>
			<xsl:when test="$month = 7">июля</xsl:when>
			<xsl:when test="$month = 8">августа</xsl:when>
			<xsl:when test="$month = 9">сентября</xsl:when>
			<xsl:when test="$month = 10">октября</xsl:when>
			<xsl:when test="$month = 11">ноября</xsl:when>
			<xsl:otherwise>декабря</xsl:otherwise>
		</xsl:choose>&#160;<xsl:value-of select="substring-after($month_postfixDate, '.')"/>
	</xsl:template>	
</xsl:stylesheet>