<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE xsl:stylesheet>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:hostcms="http://www.hostcms.ru/"
	exclude-result-prefixes="hostcms">
	<xsl:output xmlns="http://www.w3.org/TR/xhtml1/strict" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" encoding="utf-8" indent="yes" method="html" omit-xml-declaration="no" version="1.0" media-type="text/xml"/>
	
	<!-- Запишем в константу ID структуры, данные для которой будут выводиться пользователю -->
	<xsl:variable name="current_structure_id" select="/site/current_structure_id"/>
	
	<xsl:template match="/site">
		
		
		
		
		
		
		<!-- Главная -->
		
		
		<!-- Выбираем узлы структуры первого уровня -->
		<xsl:apply-templates select="structure[show=1]" />
		
		
		
	</xsl:template>
	
	<xsl:template match="structure">
		<li>
			<xsl:if test="structure[show=1]">
				<xsl:attribute name="class"><!--dropdown -->uk-parent</xsl:attribute>
				
				
			</xsl:if>
			<xsl:if test="structure[show=1] and position() = 1">
				<xsl:attribute name="class"><!--dropdown first -->uk-parent</xsl:attribute>
				
			</xsl:if>
			<xsl:if test="structure[show=1] and position() = last()">
				<xsl:attribute name="class"><!--dropdown last -->uk-parent</xsl:attribute>
				
			</xsl:if>
			<!--
			Выделяем текущую страницу добавлением к li класса current,
			если это текущая страница, либо у нее есть ребенок с атрибутом id, равным текущей группе.
			-->
			<xsl:if test="$current_structure_id = @id or count(.//structure[@id=$current_structure_id]) = 1">
				<xsl:attribute name="class">uk-active</xsl:attribute>
			</xsl:if>
			
			<!-- Set $link variable -->
			<xsl:variable name="link">
				<xsl:choose>
					<!-- External link -->
					<xsl:when test="url != ''">
						<xsl:value-of disable-output-escaping="yes" select="url"/>
					</xsl:when>
					<!-- Internal link -->
					<xsl:otherwise>
						<xsl:value-of disable-output-escaping="yes" select="link"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			
			<!-- Menu Node -->
			<a href="http://snab-lift.com.ua{$link}" title="{name}" uk-scroll="" hostcms:id="{@id}" hostcms:field="name" hostcms:entity="structure" >
				<!--
				<xsl:if test="structure[show=1]">
					<xsl:attribute name="data-toggle">dropdown</xsl:attribute>
					<xsl:attribute name="class">dropdown-toggle</xsl:attribute>
				</xsl:if>
				-->
				<xsl:value-of disable-output-escaping="yes" select="name"/>
				<!--
				<xsl:if test="structure[show=1]">-->
					<!--<i class="fa fa-angle-down"></i>-->
					<!--</xsl:if>
				-->
			</a>
			
			<xsl:if test="structure[show=1]">
				
				<div class="uk-navbar-dropdown" id="{@id}">
					<ul class="uk-nav uk-navbar-dropdown-nav" id="menu1">
						<xsl:apply-templates select="structure[show=1]" mode="submenu" />
					</ul>
				</div>
				
			</xsl:if>
		</li>
	</xsl:template>
	
	<xsl:template match="structure" mode="submenu">
		<li>
			<xsl:if test="structure[show=1]">
				<!--<xsl:attribute name="class">uk-nav-header uk-nav-divider</xsl:attribute>-->
				<xsl:attribute name="class"></xsl:attribute>
			</xsl:if>
			<!-- Set $link variable -->
			<xsl:variable name="link">
				<xsl:choose>
					<!-- External link -->
					<xsl:when test="url != ''">
						<xsl:value-of disable-output-escaping="yes" select="url"/>
					</xsl:when>
					<!-- Internal link -->
					<xsl:otherwise>
						<xsl:value-of disable-output-escaping="yes" select="link"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			
			<!-- Menu Node -->
			<a href="{$link}" title="{name}" hostcms:id="{@id}" hostcms:field="name" hostcms:entity="structure" data-toggle="dropdown" class="dropdown-toggle" onclick="location.href = this.href">
				<xsl:value-of disable-output-escaping="yes" select="name"/>
			</a>
			
			<xsl:choose>
				<xsl:when test="structure[show=1]">
					<!--<i class="fa fa-angle-right"></i>-->
				</xsl:when>
				<xsl:otherwise></xsl:otherwise>
			</xsl:choose>
			
			<xsl:if test="structure[show=1]">
				<!--	<ul class="dropdown-menu sub-menu">
					<xsl:apply-templates select="structure[show=1]" mode="sub-submenu" />
				</ul>-->
			</xsl:if>
		</li>
	</xsl:template>
	
	<xsl:template match="structure" mode="sub-submenu">
		<li>
			<xsl:if test="structure[show=1]">
				<xsl:attribute name="class">dropdown</xsl:attribute>
			</xsl:if>
			<!-- Set $link variable -->
			<xsl:variable name="link">
				<xsl:choose>
					<!-- External link -->
					<xsl:when test="url != ''">
						<xsl:value-of disable-output-escaping="yes" select="url"/>
					</xsl:when>
					<!-- Internal link -->
					<xsl:otherwise>
						<xsl:value-of disable-output-escaping="yes" select="link"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			
			<!-- Menu Node -->
			<a href="{$link}" title="{name}" hostcms:id="{@id}" hostcms:field="name" hostcms:entity="structure" data-toggle="dropdown" class="dropdown-toggle" onclick="location.href = this.href"><xsl:value-of disable-output-escaping="yes" select="name"/></a>
		</li>
	</xsl:template>
</xsl:stylesheet>