<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE xsl:stylesheet>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:hostcms="http://www.hostcms.ru/"
	exclude-result-prefixes="hostcms">
	
	<xsl:output xmlns="http://www.w3.org/TR/xhtml1/strict" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" encoding="utf-8" indent="yes" method="html" omit-xml-declaration="no" version="1.0" media-type="text/xml"/>
	
	<!-- СписокЭлементовИнфосистемы -->
	
	<xsl:template match="/">
		<xsl:apply-templates select="/informationsystem"/>
	</xsl:template>
	
	<xsl:variable name="n" select="number(3)"/>
	
	<xsl:template match="/informationsystem">
		
		<SCRIPT type="text/javascript" language="JavaScript">
			<xsl:comment>
				<xsl:text disable-output-escaping="yes">
					<![CDATA[
					$(document).ready(function() {
					$("#form_valid").validate({
					focusInvalid: true,
					errorClass: "input_error"
					})
					});
					]]>
				</xsl:text>
			</xsl:comment>
		</SCRIPT>
		
		<style>
			input.required.input_error, textarea.required.input_error{
			border:1px solid red;
			}
		</style>
		
		<!-- Получаем ID родительской группы и записываем в переменную $group -->
		<xsl:variable name="group" select="group"/>
		
		<!-- Если в находимся корне - выводим название информационной системы -->
		<xsl:choose>
			<xsl:when test="$group = 0">
				<h1 hostcms:id="{@id}" hostcms:field="name" hostcms:entity="informationsystem">
					<xsl:value-of select="name"/>
				</h1>
				
				<!-- Описание выводится при отсутствии фильтрации по тэгам -->
				<xsl:if test="count(tag) = 0 and page = 0 and description != ''">
					<div hostcms:id="{@id}" hostcms:field="description" hostcms:entity="informationsystem" hostcms:type="wysiwyg"><xsl:value-of disable-output-escaping="yes" select="description"/></div>
				</xsl:if>
			</xsl:when>
			<xsl:otherwise>
				<h1 hostcms:id="{$group}" hostcms:field="name" hostcms:entity="informationsystem_group">
					<xsl:value-of select=".//informationsystem_group[@id=$group]/name"/>
				</h1>
				
				<!-- Описание выводим только на первой странице -->
				<xsl:if test="page = 0 and .//informationsystem_group[@id=$group]/description != ''">
					<div hostcms:id="{$group}" hostcms:field="description" hostcms:entity="informationsystem_group" hostcms:type="wysiwyg"><xsl:value-of disable-output-escaping="yes" select=".//informationsystem_group[@id=$group]/description"/></div>
				</xsl:if>
				
				<!-- Путь к группе -->
				<p>
					<xsl:apply-templates select=".//informationsystem_group[@id=$group]" mode="breadCrumbs"/>
				</p>
			</xsl:otherwise>
		</xsl:choose>
		
		<xsl:if test="error !=''">
			<div class="error" style="font-weight:bold;"><xsl:value-of disable-output-escaping="yes" select="error"/></div>
		</xsl:if>
		
		<xsl:if test="count(informationsystem_item_properties/property)>0">
			<form method="post" id="form_valid" class="uk-form-horizontal"  enctype="multipart/form-data" >
				
				<xsl:apply-templates select="informationsystem_item_properties/property"/>
				
				
				<!--капча-->
				<xsl:if test="/informationsystem/captcha_id != 0 and /informationsystem/siteuser_id = 0">
					<div class="uk-margin">
						<label class="uk-form-label"></label>
						<div class="uk-form-controls">
							<img id="guestBookForm" class="captcha" src="/captcha.php?id={/informationsystem/captcha_id}&amp;height=30&amp;width=100" title="Контрольное число" name="captcha"/>
							
							<div class="captcha">
								<img src="/images/refresh.png" /> <span onclick="$('#guestBookForm').updateCaptcha('{/informationsystem/captcha_id}', 30); return false">Показать другое число</span>
							</div>
						</div>
					</div>
					
					<div class="uk-margin">
						<label class="uk-form-label">
					Контрольное число<sup><font color="red">*</font></sup>
						</label>
						<div class="uk-form-controls">
							<input type="hidden" name="captcha_id" value="{/informationsystem/captcha_id}"/>
							<input type="text" name="captcha" size="15"/>
						</div>
					</div>
				</xsl:if>
				
				<div class="uk-margin">
					<label class="uk-form-label"></label>
					<div class="uk-form-controls">
						<input type="submit" name="submit_form" value="Отправить" class="uk-button uk-button-primary"/>
					</div>
				</div>
				
			</form>
		</xsl:if>
		
		
	</xsl:template>
	
	<!-- Вывод строки со значением свойства -->
	<xsl:template match="property">
		
		<div class="uk-margin">
			<label class="uk-form-label"><xsl:value-of select="name"/></label>
			<div class="uk-form-controls">
				<xsl:choose>
					<xsl:when test="type = 1"><!--текстовое поле-->
						<input class="{tag_name} uk-input" name="property_{@id}" type="text" value="" />
					</xsl:when>
					<xsl:when test="type = 2"><!--файл-->
						<input class="{tag_name}" name="file_{@id}" type="file" /> (допускаются .jpg и .png файлы не более 1мб)
					</xsl:when>
					<xsl:when test="type = 3"><!--список-->
						<select class="{tag_name}" name="property_{@id}">
							<xsl:apply-templates select="list/list_item"/>
						</select>
					</xsl:when>
					<xsl:when test="type = 4"><!--textarea-->
						<textarea class="{tag_name} uk-textarea" rows="5" name="property_{@id}"></textarea>
					</xsl:when>
					<xsl:when test="type = 7"><!--checkbox-->
						<input class="{tag_name}" name="property_{@id}" type="checkbox" />
					</xsl:when>
				</xsl:choose>
			</div>
		</div>
		
	</xsl:template>
	
	<xsl:template match="list/list_item">
		<option value="{@id}">
			<xsl:value-of disable-output-escaping="yes" select="value"/>
		</option>
	</xsl:template>
	
</xsl:stylesheet>