<?php
/**
 * Online shop.
 *
 * @package HostCMS
 * @version 6.x
 * @author Hostmake LLC
 * @copyright © 2005-2019 ООО "Хостмэйк" (Hostmake LLC), http://www.hostcms.ru
 */
require_once('../../../../bootstrap.php');

Core_Auth::authorization($sModule = 'shop');

// Код формы
$iAdmin_Form_Id = 252;
$sAdminFormAction = '/admin/shop/warehouse/inventory/index.php';

$oAdmin_Form = Core_Entity::factory('Admin_Form', $iAdmin_Form_Id);

// Идентификатор магазина
$shop_id = intval(Core_Array::getGet('shop_id'));
// Идентификатор группы товаров
$shop_group_id = intval(Core_Array::getGet('shop_group_id', 0));

$printlayout_id = intval(Core_Array::getGet('printlayout_id', 0));

// Текущий магазин
$oShop = Core_Entity::factory('Shop')->find($shop_id);
// Текущая группа магазинов
$oShopDir = $oShop->Shop_Dir;

$sFormTitle = Core::_('Shop_Warehouse_Inventory.title');

// Контроллер формы
$oAdmin_Form_Controller = Admin_Form_Controller::create($oAdmin_Form);
$oAdmin_Form_Controller
	->module(Core_Module::factory($sModule))
	->setUp()
	->path($sAdminFormAction)
	->title($sFormTitle)
	->pageTitle($sFormTitle);

if (!is_null(Core_Array::getPost('update_warehouse_counts')) && Core_Array::getPost('shop_warehouse_id'))
{
	$aJSON = array();

	$shop_warehouse_id = intval(Core_Array::getPost('shop_warehouse_id'));
	$datetime = Core_Date::datetime2sql(Core_Array::getPost('datetime'));
	$aItems = Core_Array::getPost('items');

	foreach ($aItems as $shop_item_id)
	{
		$oShop_Item = Core_Entity::factory('Shop_Item')->getById($shop_item_id);
		$oShop_Warehouse = Core_Entity::factory('Shop_Warehouse')->getById($shop_warehouse_id);

		if (!is_null($oShop_Item) && !is_null($oShop_Warehouse))
		{
			$oShop_Item = $oShop_Item->shortcut_id
				? $oShop_Item->Shop_Item
				: $oShop_Item;

			$rest = $oShop_Warehouse->getRest($oShop_Item->id, $datetime);
			is_null($rest) && $rest = 0;

			$aJSON[$oShop_Item->id] = array(
				'count' => $rest
			);
		}
	}

	Core::showJson($aJSON);
}

/*if (!is_null(Core_Array::getPost('load_warehouse_counts')) && Core_Array::getPost('shop_warehouse_id'))
{
	$aJSON = array();

	$shop_warehouse_id = intval(Core_Array::getPost('shop_warehouse_id'));
	$aItems = Core_Array::getPost('items');

	foreach ($aItems as $shop_item_id)
	{
		$oShop_Item = Core_Entity::factory('Shop_Item')->getById($shop_item_id);

		if (!is_null($oShop_Item))
		{
			$oShop_Item = $oShop_Item->shortcut_id
				? $oShop_Item->Shop_Item
				: $oShop_Item;

			$factWarehouseCount = $factWarehouseSum = '0.00';

			$oShop_Warehouse_Items = Core_Entity::factory('Shop_Warehouse_Item');
			$oShop_Warehouse_Items->queryBuilder()
				->where('shop_warehouse_items.shop_warehouse_id', '=', $shop_warehouse_id)
				->where('shop_warehouse_items.shop_item_id', '=', $oShop_Item->id)
				->limit(1);

			$aShop_Warehouse_Items = $oShop_Warehouse_Items->findAll();

			if (isset($aShop_Warehouse_Items[0]))
			{
				$factWarehouseCount = floatval($aShop_Warehouse_Items[0]->count);
			}

			$factWarehouseSum = floatval($factWarehouseCount * $oShop_Item->price);

			$aJSON[$oShop_Item->id] = array(
				'count' => $factWarehouseCount,
				'sum' => round($factWarehouseSum, 2)
			);
		}
	}

	Core::showJson($aJSON);
}*/

// Меню формы
$oAdmin_Form_Entity_Menus = Admin_Form_Entity::factory('Menus');

// Элементы меню
$oAdmin_Form_Entity_Menus->add(
	Admin_Form_Entity::factory('Menu')
		->name(Core::_('Admin_Form.add'))
		->icon('fa fa-plus')
		->img('/admin/images/company_add.gif')
		->href(
			$oAdmin_Form_Controller->getAdminActionLoadHref($oAdmin_Form_Controller->getPath(), 'edit', NULL, 0, 0)
		)
		->onclick(
			$oAdmin_Form_Controller->getAdminActionLoadAjax($oAdmin_Form_Controller->getPath(), 'edit', NULL, 0, 0)
		)
);

// Добавляем все меню контроллеру
$oAdmin_Form_Controller->addEntity($oAdmin_Form_Entity_Menus);

// Представитель класса хлебных крошек
$oAdmin_Form_Entity_Breadcrumbs = Admin_Form_Entity::factory('Breadcrumbs');

$oAdmin_Form_Entity_Breadcrumbs->add(
	Admin_Form_Entity::factory('Breadcrumb')
	->name(Core::_('Shop.menu'))
	->href($oAdmin_Form_Controller->getAdminLoadHref($sShopItemFormPath = '/admin/shop/index.php', NULL, NULL, ''))
	->onclick($oAdmin_Form_Controller->getAdminLoadAjax($sShopItemFormPath, NULL, NULL, ''))
);

$oAdmin_Form_Controller->addEntity($oAdmin_Form_Entity_Breadcrumbs);

// Добавляем крошки для групп магазинов
if ($oShopDir->id)
{
	$aBreadcrumbs = array();

	$oShopBreadCrumbDir = $oShopDir;

	do
	{
		$additionalParams = "shop_dir_id={$oShopBreadCrumbDir->id}";

		$aBreadcrumbs[] = Admin_Form_Entity::factory('Breadcrumb')
			->name($oShopBreadCrumbDir->name)
			->href($oAdmin_Form_Controller->getAdminLoadHref($sShopItemFormPath, NULL, NULL, $additionalParams))
			->onclick($oAdmin_Form_Controller->getAdminLoadAjax($sShopItemFormPath, NULL, NULL, $additionalParams));
	}
	while ($oShopBreadCrumbDir = $oShopBreadCrumbDir->getParent());

	$aBreadcrumbs = array_reverse($aBreadcrumbs);

	foreach ($aBreadcrumbs as $oAdmin_Form_Entity_Breadcrumb)
	{
		$oAdmin_Form_Entity_Breadcrumbs->add(
			$oAdmin_Form_Entity_Breadcrumb
		);
	}
}

// Добавляем крошку на форму списка групп товаров и товаров
$oAdmin_Form_Entity_Breadcrumbs->add(
	Admin_Form_Entity::factory('Breadcrumb')
		->name($oShop->name)
		->href($oAdmin_Form_Controller->getAdminLoadHref('/admin/shop/item/index.php', NULL, NULL, $sAdditionalParams = "shop_id={$oShop->id}&shop_group_id=0"))
		->onclick($oAdmin_Form_Controller->getAdminLoadAjax('/admin/shop/item/index.php', NULL, NULL, $sAdditionalParams))
);

// Крошки строим только если: мы не в корне или идет редактирование
if ($shop_group_id)
{
	$oShopGroup = Core_Entity::factory('Shop_Group', $shop_group_id);

	// Массив хлебных крошек
	$aBreadcrumbs = array();

	$sShopItemFormPath = '/admin/shop/item/index.php';

	do
	{
		$additionalParams = "shop_id={$oShop->id}&shop_group_id={$oShopGroup->id}";

		$aBreadcrumbs[] = Admin_Form_Entity::factory('Breadcrumb')
			->name($oShopGroup->name)
			->href($oAdmin_Form_Controller->getAdminLoadHref($sShopItemFormPath, NULL, NULL, $additionalParams))
			->onclick($oAdmin_Form_Controller->getAdminLoadAjax($sShopItemFormPath, NULL, NULL, $additionalParams));
	}
	while ($oShopGroup = $oShopGroup->getParent());

	$aBreadcrumbs = array_reverse($aBreadcrumbs);

	foreach ($aBreadcrumbs as $oAdmin_Form_Entity_Breadcrumb)
	{
		$oAdmin_Form_Entity_Breadcrumbs->add(
			$oAdmin_Form_Entity_Breadcrumb
		);
	}
}

// Добавляем крошку на текущую форму
$oAdmin_Form_Entity_Breadcrumbs->add(
	Admin_Form_Entity::factory('Breadcrumb')
		->name(Core::_('Shop_Warehouse.main_menu_warehouses_list'))
		->href($oAdmin_Form_Controller->getAdminLoadHref('/admin/shop/warehouse/index.php', NULL, NULL, $sAdditionalParams = "shop_id={$oShop->id}&shop_group_id={$shop_group_id}"))
		->onclick($oAdmin_Form_Controller->getAdminLoadAjax('/admin/shop/warehouse/index.php', NULL, NULL, $sAdditionalParams))
)->add(
	Admin_Form_Entity::factory('Breadcrumb')
		->name($sFormTitle)
		->href($oAdmin_Form_Controller->getAdminLoadHref($oAdmin_Form_Controller->getPath(), NULL, NULL, $sAdditionalParams = "&shop_id={$oShop->id}&shop_group_id={$shop_group_id}"))
		->onclick($oAdmin_Form_Controller->getAdminLoadAjax($oAdmin_Form_Controller->getPath(), NULL, NULL, $sAdditionalParams))
);

// Действие редактирования
$oAdmin_Form_Action = Core_Entity::factory('Admin_Form', $iAdmin_Form_Id)
	->Admin_Form_Actions
	->getByName('edit');

if ($oAdmin_Form_Action && $oAdmin_Form_Controller->getAction() == 'edit')
{
	$Shop_Warehouse_Controller_Edit = Admin_Form_Action_Controller::factory(
		'Shop_Warehouse_Inventory_Controller_Edit', $oAdmin_Form_Action
	);

	$Shop_Warehouse_Controller_Edit->addEntity($oAdmin_Form_Entity_Breadcrumbs);

	// Добавляем типовой контроллер редактирования контроллеру формы
	$oAdmin_Form_Controller->addAction($Shop_Warehouse_Controller_Edit);
}

// Действие "Применить"
$oAdminFormActionApply = Core_Entity::factory('Admin_Form', $iAdmin_Form_Id)
	->Admin_Form_Actions
	->getByName('apply');

if ($oAdminFormActionApply && $oAdmin_Form_Controller->getAction() == 'apply')
{
	$Admin_Form_Action_Controller_Type_Apply = Admin_Form_Action_Controller::factory(
		'Admin_Form_Action_Controller_Type_Apply', $oAdminFormActionApply
	);

	// Добавляем контроллер редактирования контроллеру формы
	$oAdmin_Form_Controller->addAction($Admin_Form_Action_Controller_Type_Apply);
}

// Удаление товаров из комплекта
$oAdminFormActionDeleteShopItem = Core_Entity::factory('Admin_Form', $iAdmin_Form_Id)
	->Admin_Form_Actions
	->getByName('deleteShopItem');

if ($oAdminFormActionDeleteShopItem && $oAdmin_Form_Controller->getAction() == 'deleteShopItem')
{
	$Shop_Warehouse_Inventory_Item_Controller_Delete = Admin_Form_Action_Controller::factory(
		'Shop_Warehouse_Inventory_Item_Controller_Delete', $oAdminFormActionDeleteShopItem
	);

	$oAdmin_Form_Controller->addAction($Shop_Warehouse_Inventory_Item_Controller_Delete);
}

$oAdmin_Form_Action = Core_Entity::factory('Admin_Form', $iAdmin_Form_Id)
	->Admin_Form_Actions
	->getByName('print');

if ($oAdmin_Form_Action && $oAdmin_Form_Controller->getAction() == 'print')
{
	$Shop_Warehouse_Inventory_Controller_Print = Admin_Form_Action_Controller::factory(
		'Shop_Warehouse_Inventory_Controller_Print', $oAdmin_Form_Action
	);

	$Shop_Warehouse_Inventory_Controller_Print
		->title(Core::_('Shop_Warehouse_Inventory.title'))
		->printlayout($printlayout_id);

	// Добавляем типовой контроллер редактирования контроллеру формы
	$oAdmin_Form_Controller->addAction($Shop_Warehouse_Inventory_Controller_Print);
}

$oAdmin_Form_Action = Core_Entity::factory('Admin_Form', $iAdmin_Form_Id)
	->Admin_Form_Actions
	->getByName('sendMail');

if ($oAdmin_Form_Action && $oAdmin_Form_Controller->getAction() == 'sendMail')
{
	$Shop_Warehouse_Inventory_Controller_Print = Admin_Form_Action_Controller::factory(
		'Shop_Warehouse_Inventory_Controller_Print', $oAdmin_Form_Action
	);

	$Shop_Warehouse_Inventory_Controller_Print
		->printlayout($printlayout_id)
		->send(TRUE);

	// Добавляем типовой контроллер редактирования контроллеру формы
	$oAdmin_Form_Controller->addAction($Shop_Warehouse_Inventory_Controller_Print);
}

$oAdmin_Form_Action = Core_Entity::factory('Admin_Form', $iAdmin_Form_Id)
	->Admin_Form_Actions
	->getByName('post');

if ($oAdmin_Form_Action && $oAdmin_Form_Controller->getAction() == 'post')
{
	$Admin_Form_Action_Controller_Type_Post = Admin_Form_Action_Controller::factory(
		'Admin_Form_Action_Controller_Type_Post', $oAdmin_Form_Action
	);

	// Добавляем типовой контроллер редактирования контроллеру формы
	$oAdmin_Form_Controller->addAction($Admin_Form_Action_Controller_Type_Post);
}

// Источник данных 0
$oAdmin_Form_Dataset = new Admin_Form_Dataset_Entity(
	Core_Entity::factory('Shop_Warehouse_Inventory')
);

// Добавляем источник данных контроллеру формы
$oAdmin_Form_Controller->addDataset(
	$oAdmin_Form_Dataset
);

$oAdmin_Form_Dataset->addCondition(
	array('select' => array('shop_warehouse_inventories.*'))
)
->addCondition(
	array(
		'leftJoin' => array('shop_warehouses', 'shop_warehouses.id', '=', 'shop_warehouse_inventories.shop_warehouse_id')
	)
)
->addCondition(
	array(
		'where' => array('shop_warehouses.shop_id', '=', $shop_id)
	)
);

$oAdmin_Form_Controller->addFilter('user_id', array($oAdmin_Form_Controller, '_filterCallbackUser'));

// Показ формы
$oAdmin_Form_Controller->execute();