<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE xsl:stylesheet>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:hostcms="http://www.hostcms.ru/"
	exclude-result-prefixes="hostcms">

	<xsl:output xmlns="http://www.w3.org/TR/xhtml1/strict" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" encoding="utf-8" indent="yes" method="html" omit-xml-declaration="no" version="1.0" media-type="text/xml"/>

	<!-- ФинансыПортфолио -->

	<xsl:template match="/">
		<xsl:apply-templates select="/informationsystem/informationsystem_item"/>
	</xsl:template>

	<xsl:template match="informationsystem_item">
		<section class="main-home">
			<div class="container">
				<header>
					<h2><xsl:value-of select="name"/></h2>
					<div class="separator-small"></div>
				</header>
			</div>
		</section>
		<section class="main-portfolio">
			<div class="container">
				<div class="row">
					<div class="col-xs-12 col-md-7">
						<xsl:if test="image_large != ''">
							<img class="img-responsive" src="{dir}{image_large}" alt="{name}" />
						</xsl:if>
					</div>
					<div class="col-xs-12 col-md-5">
						<xsl:value-of disable-output-escaping="yes" select="text"/>
					</div>
				</div>
			</div>
		</section>

		<section class="main-home">
			<div class="container">
				<header>
					<h2>Другие выполненные работы</h2>
					<div class="separator-small"></div>
				</header>
			</div>
		</section>
		<section class="main-portfolio">
			<div class="container">
				<div class="row">
					<xsl:apply-templates select="/informationsystem/same_items/informationsystem_item" mode="same"/>
				</div>
			</div>
		</section>
	</xsl:template>

	<xsl:template match="informationsystem_item" mode="same">
		<div class="col-xs-12 col-md-3">
			<a href="{url}"><img class="img-responsive same-item" src="{dir}{image_large}" alt="{name}" /></a>
		</div>
	</xsl:template>
</xsl:stylesheet>