<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE xsl:stylesheet>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:hostcms="http://www.hostcms.ru/"
	exclude-result-prefixes="hostcms">
	<xsl:output xmlns="http://www.w3.org/TR/xhtml1/strict" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" encoding="utf-8" indent="yes" method="html" omit-xml-declaration="no" version="1.0" media-type="text/xml"/>
	
	<!-- СписокНовостейНаГлавной -->
	
	<xsl:template match="/">
		<xsl:apply-templates select="/informationsystem"/>
	</xsl:template>
	
	<xsl:template match="/informationsystem">
		<!-- Выводим название информационной системы -->
		<!--<p class="h1" hostcms:id="{@id}" hostcms:field="name" hostcms:entity="informationsystem">
			
			<xsl:value-of select="name"/>
		</p>-->
		
		
		<h1 class="uk-margin-large-bottom uk-text-center uk-text-bold" hostcms:id="{@id}" hostcms:field="name" hostcms:entity="informationsystem"><xsl:value-of select="name"/></h1>
		
		<!-- Отображение записи информационной системы -->
		<xsl:if test="informationsystem_item">
			<div class="uk-child-width-1-2@s uk-grid-large" uk-grid="">
				<xsl:apply-templates select="informationsystem_item"/>
			</div>
		</xsl:if>
		
	<!--<p><a href="{url}" class="uk-button" title="Все отзывы">Все отзывы</a></p>-->
	</xsl:template>
	
	<!-- Шаблон вывода информационного элемента -->
	<xsl:template match="informationsystem_item">
		
		<div>
			<div class="uk-card uk-card-small uk-card-body">
				
				<div uk-grid="">
				<div class="uk-width-auto@m"><i class="fas fa-user-edit"></i></div>
					<div class="uk-width-expand@m">
						
						<div>
							<xsl:value-of disable-output-escaping="yes" select="description"/>
						</div>
						<p class="uk-text-bold"><xsl:value-of select="name"/></p>
						
					</div>
				</div>
				
				
			</div>
		</div>
		
		
		<!--
		<div>
			<div class="uk-card  uk-card-tm uk-card-body">
				
				<div class="uk-card-badge uk-label">Badge</div>
				<h3 class="uk-card-title">Title</h3>
				
				<xsl:if test="name != ''">
					<div class="uk-card-title"><xsl:value-of select="name"/></div>
				</xsl:if>
				<p><xsl:value-of disable-output-escaping="yes" select="description"/></p>
			</div>
			
			<div class="uk-flex uk-flex-middle uk-margin uk-margin-medium-top uk-position-relative">
				
				<div id="triangle_down"></div>
				<style>
					.uk-card-tm{background-color:#f5f5f5;}
					#triangle_down {
					position: absolute;
					top: -40px;
					width: 0;
					height: 0;
					border-top: 20px solid #f5f5f5;
					border-left: 0px solid transparent;
					border-right: 15px solid transparent;
					}
				</style>
				<img class="uk-border-circle uk-margin-small-right" src="{dir}{image_small}"  alt="{name}" />
				<span class="uk-margin-small-right" uk-icon="icon: minus"></span><xsl:value-of select="property_value[tag_name='author']/value"/>
			</div>
			
			
		</div>
		-->
		
		<!--
		<li>
			
			
			<ul class="uk-grid uk-grid-width-1-2 uk-grid-width-medium-1-2 uk-grid-width-large-1-2 uk-flex uk-flex-middle">
				<li><img src="{dir}{image_small}"   alt="{name}"  /></li>
				<li>
					
					<p class="news-date">
						<i class="uk-icon-clock-o"></i>
						<xsl:value-of select="substring-before(date, '.')"/>
						<xsl:variable name="month_year" select="substring-after(date, '.')"/>
						<xsl:variable name="month" select="substring-before($month_year, '.')"/> /
						<xsl:choose>
							<xsl:when test="$month = 1"> 01 </xsl:when>
							<xsl:when test="$month = 2"> 02 </xsl:when>
							<xsl:when test="$month = 3"> 03 </xsl:when>
							<xsl:when test="$month = 4"> 04 </xsl:when>
							<xsl:when test="$month = 5"> 05 </xsl:when>
							<xsl:when test="$month = 6"> 06 </xsl:when>
							<xsl:when test="$month = 7"> 07 </xsl:when>
							<xsl:when test="$month = 8"> 08 </xsl:when>
							<xsl:when test="$month = 9"> 09 </xsl:when>
							<xsl:when test="$month = 10"> 10 </xsl:when>
							<xsl:when test="$month = 11"> 11 </xsl:when>
							<xsl:otherwise> 12 </xsl:otherwise>
						</xsl:choose>
					/ <xsl:value-of select="substring-after($month_year, '.')"/><xsl:text></xsl:text>
					</p>
					
					<p class="news-name">
						<a href="{url}" hostcms:id="{@id}" hostcms:field="name" hostcms:entity="informationsystem_item">
							<xsl:value-of select="name"/>
						</a>
						
					</p>
					<p><xsl:value-of disable-output-escaping="yes" select="description"/></p>
					
				</li>
			</ul>
			
		</li>
		-->
		
		
		
	</xsl:template>
</xsl:stylesheet>