<?php

defined('HOSTCMS') || exit('HostCMS: access denied.');

/**
 * Core command controller.
 *
 * @package HostCMS
 * @subpackage Core\Command
 * @version 6.x
 * @author Hostmake LLC
 * @copyright © 2005-2019 ООО "Хостмэйк" (Hostmake LLC), http://www.hostcms.ru
 */
class Core_Command_Controller_Site_Closed extends Core_Command_Controller
{
	/**
	 * Default controller action
	 * @return Core_Response
	 * @hostcms-event Core_Command_Controller_Site_Closed.onBeforeShowAction
	 * @hostcms-event Core_Command_Controller_Site_Closed.onAfterShowAction
	 */
	public function showAction()
	{
		Core_Event::notify(get_class($this) . '.onBeforeShowAction', $this);

		$oSite = Core_Entity::factory('Site', CURRENT_SITE);

		if ($oSite->closed)
		{
			return Core_Router::factory(
				Core_Entity::factory('Structure', $oSite->closed)->getPath()
			)->execute()->status(503);
		}

		$oCore_Response = new Core_Response();

		Core_Page::instance()
			->response($oCore_Response);
		
		$oCore_Response
			->status(503)
			->header('Content-Type', "text/html; charset=UTF-8")
			->header('Last-Modified', gmdate('D, d M Y H:i:s', time()) . ' GMT')
			->header('X-Powered-By', 'HostCMS');

		$domain = htmlspecialchars(Core::$url['host']);

		$title = "Сайт {$domain} отключен администратором и в данный момент недоступен!";

		ob_start();
		$oSkin = Core_Skin::instance()
			->title($title)
			->header();

		$oSkin = Core_Skin::instance()
			->title($title)
			->setMode('authorization')
			->header();

		Core::factory('Core_Html_Entity_Div')
			->class('indexMessage')
			->add(Core::factory('Core_Html_Entity_H1')->value($title))
			->add(Core::factory('Core_Html_Entity_P')->value(
				'Для включения сайта перейдите в&nbsp;раздел &laquo;Сайты&raquo; и&nbsp;установите значение &laquo;Активность&raquo; требуемого сайта.'
			))
			->execute();

		$oSkin->footer();

		$oCore_Response->body(ob_get_clean());

		Core_Event::notify(get_class($this) . '.onAfterShowAction', $this, array($oCore_Response));

		return $oCore_Response;
	}
}